/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipStringBuffer {
    int complen = 0;
    private int CHUNK_SIZE = 10240;
    ArrayList chunks = new ArrayList();
    Chunk openChunk = new Chunk(null);
    StringBuffer tail = new StringBuffer();

    public ZipStringBuffer() {
    }

    public ZipStringBuffer(String val) {
        this.append(val);
    }

    public ZipStringBuffer(boolean useZip) {
        if (!useZip) {
            this.CHUNK_SIZE = Integer.MAX_VALUE;
        }
    }

    public ZipStringBuffer(int chunk_size) {
        this.CHUNK_SIZE = chunk_size;
        if (this.CHUNK_SIZE < 1024) {
            this.CHUNK_SIZE = 1024;
        }
    }

    public int compressedLength() {
        return this.complen + this.tail.length();
    }

    public int length() {
        return this.chunks.size() * this.CHUNK_SIZE + this.tail.length();
    }

    private void updateChunks() {
        while (this.tail.length() > this.CHUNK_SIZE) {
            String buf = this.tail.substring(0, this.CHUNK_SIZE);
            this.tail.delete(0, this.CHUNK_SIZE);
            this.addChunk(new StringBuffer(buf));
        }
    }

    private void addChunk(StringBuffer sb) {
        Chunk chunk = new Chunk(sb);
        chunk.shrink();
        this.chunks.add(chunk);
        this.complen += chunk.dat.length;
    }

    public ZipStringBuffer append(Object o) {
        this.tail.append(o);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(String o) {
        this.tail.append(o);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(int c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(double c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(float c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(long c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(byte c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(boolean c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char[] c) {
        this.tail.append(c);
        this.updateChunks();
        return this;
    }

    public ZipStringBuffer append(char[] c, int offset, int len) {
        this.tail.append(c, offset, len);
        this.updateChunks();
        return this;
    }

    public char charAt(int n) {
        int index = n / this.CHUNK_SIZE;
        int offset = n % this.CHUNK_SIZE;
        if (index >= this.chunks.size()) {
            return this.tail.charAt(offset);
        }
        Chunk chunk = (Chunk)this.chunks.get(index);
        if (chunk != this.openChunk) {
            this.openChunk.shrink();
            this.openChunk = chunk;
        }
        chunk.grow();
        return chunk.sb.charAt(offset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        String s = this.substring(srcBegin, srcEnd);
        s.getChars(0, s.length(), dst, dstBegin);
    }

    public String substring(int begin) {
        return this.substring(begin, this.length());
    }

    public String substring(int begin, int end) {
        if (begin == end) {
            return "";
        }
        int s_index = begin / this.CHUNK_SIZE;
        int s_offset = begin % this.CHUNK_SIZE;
        int f_index = (end - 1) / this.CHUNK_SIZE;
        int f_offset = (end - 1) % this.CHUNK_SIZE;
        if (s_index >= this.chunks.size()) {
            return this.tail.substring(s_offset, f_offset);
        }
        StringBuffer sb = new StringBuffer();
        Chunk chunk = (Chunk)this.chunks.get(s_index);
        chunk.grow();
        sb.append(chunk.sb.substring(s_offset));
        chunk.shrink();
        for (int i = s_index + 1; i < f_index; ++i) {
            chunk = (Chunk)this.chunks.get(i);
            chunk.grow();
            sb.append(chunk.sb.toString());
            chunk.shrink();
        }
        if (f_index >= this.chunks.size()) {
            sb.append(this.tail.substring(0, f_offset + 1));
        } else {
            chunk = (Chunk)this.chunks.get(f_index);
            chunk.grow();
            sb.append(chunk.sb.substring(0, f_offset + 1));
            chunk.shrink();
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.chunks.size(); ++i) {
            Chunk chunk = (Chunk)this.chunks.get(i);
            chunk.grow();
            sb.append(chunk.sb.toString());
        }
        sb.append(this.tail.toString());
        return sb.toString();
    }

    public void toStream(OutputStream out) throws IOException {
        for (int i = 0; i < this.chunks.size(); ++i) {
            Chunk chunk = (Chunk)this.chunks.get(i);
            chunk.grow();
            out.write(chunk.sb.toString().getBytes());
        }
        out.write(this.tail.toString().getBytes());
    }

    public int indexOf(char c, int index) {
        while (index < this.length()) {
            if (this.charAt(index) == c) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int index = this.length() - 1; index > 0; --index) {
            if (this.charAt(index) != c) continue;
            return index;
        }
        return -1;
    }

    private byte[] compress(byte[] dat) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(bout);
        gzout.write(dat, 0, dat.length);
        gzout.finish();
        gzout.close();
        return bout.toByteArray();
    }

    private byte[] decompress(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        GZIPInputStream gzin = new GZIPInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = gzin.read(buf, 0, 1024);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }

    class Chunk {
        boolean compressed = true;
        StringBuffer sb;
        byte[] dat;

        public Chunk(StringBuffer sb) {
            this.sb = sb;
        }

        void shrink() {
            if (this.sb == null) {
                return;
            }
            try {
                this.dat = ZipStringBuffer.this.compress(this.sb.toString().getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sb = null;
        }

        void grow() {
            if (this.dat == null) {
                return;
            }
            try {
                this.sb = new StringBuffer(new String(ZipStringBuffer.this.decompress(this.dat)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dat = null;
        }
    }
}

