/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.spinner.internal;

import java.text.DecimalFormat;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Spinner
extends Composite
implements FocusListener,
SelectionListener {
    Text text;
    Composite buttons;
    Button up;
    Button down;
    double last_good_value = 0.0;
    double min = 0.0;
    double max = 100.0;
    double increment = 1.0;
    double decimals = 0.0;
    DecimalFormat dformat;

    public Spinner(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void focusGained(FocusEvent e) {
        this.validateText();
    }

    public void focusLost(FocusEvent e) {
        this.validateText();
    }

    public void configure(int decimals, double min, double max, double increment) {
        this.min = min;
        this.max = max;
        this.increment = increment;
        this.last_good_value = min;
        StringBuffer format = new StringBuffer("#");
        if (decimals > 0) {
            format.append(".");
        }
        for (int i = 0; i < decimals; ++i) {
            format.append("0");
        }
        this.dformat = new DecimalFormat(format.toString());
    }

    public double getValue() {
        try {
            double d = Double.parseDouble(this.text.getText());
            return this.validate(d);
        }
        catch (Exception e) {
            return this.last_good_value;
        }
    }

    private void validateText() {
        try {
            double d = Double.parseDouble(this.text.getText());
            this.setValue(this.validate(d));
        }
        catch (Exception e) {
            this.setValue(this.last_good_value);
        }
    }

    private double validate(double d) {
        if (d < this.min) {
            d = this.min;
        }
        if (d > this.max) {
            d = this.max;
        }
        double mod = d % this.increment;
        d -= mod;
        if (mod > this.increment / 2.0) {
            d += this.increment;
        }
        return d;
    }

    public void setValue(double d) {
        this.last_good_value = this.validate(d);
        this.text.setText(this.dformat.format(this.last_good_value));
    }

    private void init() {
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 2;
        glayout.horizontalSpacing = 0;
        glayout.verticalSpacing = 0;
        this.setLayout((Layout)glayout);
        this.text = new Text((Composite)this, 2052);
        this.text.setLayoutData((Object)GData.getGridData(true, true, -1, 16, 1, 1, 4, 4));
        this.buttons = new Composite((Composite)this, 0);
        this.buttons.setLayoutData((Object)GData.getGridData(false, true, -1, 16, 1, 1, 4, 4));
        FillLayout rlayout = new FillLayout();
        rlayout.type = 512;
        this.buttons.setLayout((Layout)rlayout);
        this.up = new Button(this.buttons, 8);
        this.up.setImage(EditorPlugin.img.getImage("up.gif"));
        this.down = new Button(this.buttons, 8);
        this.down.setImage(EditorPlugin.img.getImage("down.gif"));
        this.text.setText("0");
        this.text.addFocusListener((FocusListener)this);
        this.up.addSelectionListener((SelectionListener)this);
        this.down.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.up) {
            double d = this.getValue();
            if ((d += this.increment) > this.max) {
                d = this.min;
            }
            this.setValue(d);
        } else if (e.getSource() == this.down) {
            double d = this.getValue();
            if ((d -= this.increment) < this.min) {
                d = this.max;
            }
            this.setValue(d);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

