/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomIndicatorsCollection {
    static final int IDEAL_WIDTH = 7;
    static final int INDENT = 6;
    ZoomSlider slider;
    Vector indicators = new Vector();
    int width = 7;
    int startPoint;

    public ZoomIndicatorsCollection(ZoomSlider slider) {
        this.slider = slider;
    }

    public void add(ZoomIndicator indicator) {
        if (indicator != null && !this.indicators.contains(indicator)) {
            this.indicators.addElement(indicator);
            this.calculatePositions();
        }
    }

    public void remove(ZoomIndicator indicator) {
        if (indicator != null && this.indicators.contains(indicator)) {
            this.indicators.removeElement(indicator);
            this.calculatePositions();
        }
    }

    public void calculatePositions() {
        if (this.indicators.size() > 0) {
            int base = this.slider.getBounds().width;
            if (this.slider.getOrientation() == 1) {
                base = this.slider.getBounds().height;
            }
            this.width = (base - 12) / this.indicators.size();
            if (this.width > 7) {
                this.width = 7;
            }
            this.startPoint = base / 2 - this.width / 2 * this.indicators.size();
        }
    }

    public void paint(GC g, Image backBuffer) {
        for (int i = 0; i < this.indicators.size(); ++i) {
            ((ZoomIndicator)this.indicators.elementAt(i)).paint(g, backBuffer, this.startPoint + i * this.width, this.width);
        }
    }

    public Vector getZoomIndicators() {
        return this.indicators;
    }

    public void setXORColors() {
        for (int i = 0; i < this.indicators.size(); ++i) {
            ((ZoomIndicator)this.indicators.elementAt(i)).setXORColor();
        }
    }

    public void dispose() {
        for (int i = 0; i < this.indicators.size(); ++i) {
            ((ZoomIndicator)this.indicators.elementAt(i)).dispose();
        }
    }
}

