/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.AdaptorEditor;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.DetailsContent;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.EditorPage;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationPage
extends EditorPage
implements ISelectionChangedListener {
    protected EditingDomain editingDomain;
    protected ConfigurationItemProviderAdapterFactory itemFactory;
    protected DetailsContent details;
    protected Composite result;
    protected TreeViewer treeViewer;

    public ConfigurationPage(RuleBuilderWidgetFactory widgetFactory, EditingDomain editingDomain) {
        super(widgetFactory);
        this.editingDomain = editingDomain;
    }

    public void createContent(Composite parent) {
        this.createHeader(parent);
        this.itemFactory = new ConfigurationItemProviderAdapterFactory();
        this.result = this.factory.createComposite(parent);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        this.result.setLayout((Layout)detailLayout);
        this.result.setLayoutData((Object)GridUtil.createFill());
        this.createDetail(this.result);
        Composite sepFooter = this.factory.createCompositeSeparator(this.result);
        GridData sepFooterGrid = GridUtil.createHorizontalFill();
        sepFooterGrid.heightHint = 3;
        sepFooterGrid.horizontalSpan = 2;
        sepFooter.setLayoutData((Object)sepFooterGrid);
        this.factory.paintChildControlsFor(this.result);
    }

    private void createDetail(Composite composite) {
        Tree tree = this.factory.createTree(composite, 770);
        this.treeViewer = new TreeViewer(tree);
        GridData dummy = GridUtil.createFill();
        dummy.widthHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)dummy);
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACAD_EDITOR_TREEVIEW);
        this.details = new DetailsContent(this.factory, this.editingDomain, this.itemFactory, this.result, 0);
        this.details.createContent();
    }

    public Control getControl() {
        return this.result;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() != null && event.getSource() instanceof AdaptorEditor) {
            ISelection selection = event.getSelection();
            Object currentSelection = null;
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                currentSelection = ((IStructuredSelection)selection).getFirstElement();
            }
            if (currentSelection instanceof EObject) {
                this.details.showDetailsFor((EObject)currentSelection);
            }
            if (currentSelection instanceof WrapperItemProvider) {
                Object value = ((WrapperItemProvider)currentSelection).getValue();
                if (value != null && value instanceof FeatureMapUtil.EntryImpl) {
                    value = ((FeatureMapUtil.EntryImpl)value).getValue();
                }
                if (value != null && value instanceof EObject) {
                    this.details.showDetailsFor((EObject)value);
                }
            }
        }
    }

    public void dispose() {
        if (this.factory != null) {
            this.factory.dispose();
        }
        this.factory = null;
        this.itemFactory = null;
        if (this.details != null) {
            this.details.dispose();
        }
        this.editingDomain = null;
    }

    private void createHeader(Composite content) {
        Composite sepHeader = this.factory.createCompositeSeparator(content);
    }

    public DetailsContent getDetails() {
        return this.details;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }
}

