/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.impl.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextRoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResourceSelectionDialog;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContextSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text descriptionText;
    protected Text execClassText;
    protected Text uniqueIDText;
    protected Text impDateText;
    protected Text impVersionText;
    protected Text impVDescrText;
    protected Text logLevelText;
    protected Text nameText;
    protected CCombo roleCombo;
    protected Text roleDateText;
    protected Text roleVersionText;
    protected Text roleVDescrText;
    protected Button browseRef;
    protected EditingDomain editingDomain;
    protected boolean isDisplaying;
    protected ContextType currentSelection;
    protected ContextTypeItemProvider itemProvider;
    protected ContextItemProviderAdapterFactory itemFactory = new ContextItemProviderAdapterFactory();

    public ContextSection(RuleBuilderWidgetFactory factory, EditingDomain editingDomain, Composite composite, int style) {
        super(composite, style);
        this.editingDomain = editingDomain;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_NAME"), 0);
        this.nameText = factory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_EXECC"), 0);
        this.execClassText = factory.createText(this, "", 2);
        this.execClassText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLCD"), 0);
        this.impDateText = factory.createText(this, "", 0);
        this.impDateText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLV"), 0);
        this.impVersionText = factory.createText(this, "", 0);
        this.impVersionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLVD"), 0);
        this.impVDescrText = factory.createText(this, "", 0);
        this.impVDescrText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_LOGL"), 0);
        this.logLevelText = factory.createText(this, "", 0);
        this.logLevelText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLE"), 0);
        this.roleCombo = factory.createCombo(this, 8);
        this.roleCombo.setLayoutData((Object)new GridData(768));
        this.initializeRoleCombo();
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLECD"), 0);
        this.roleDateText = factory.createText(this, "", 0);
        this.roleDateText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEV"), 0);
        this.roleVersionText = factory.createText(this, "", 0);
        this.roleVersionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEVD"), 0);
        this.roleVDescrText = factory.createText(this, "", 0);
        this.roleVDescrText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite refGroup = factory.createComposite(this);
        detailLayout = new GridLayout();
        detailLayout.numColumns = 3;
        detailLayout.verticalSpacing = 5;
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        refGroup.setLayoutData((Object)data);
        refGroup.setLayout((Layout)detailLayout);
        label = factory.createLabel(refGroup, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ID"), 0);
        this.uniqueIDText = factory.createText(refGroup, "", 0);
        this.uniqueIDText.setLayoutData((Object)new GridData(768));
        this.uniqueIDText.setEditable(false);
        this.browseRef = factory.createButton(refGroup, AcadEditorPlugin.getPlugin().getString("BROWSE"), 8);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.nameText.addModifyListener((ModifyListener)this);
        this.execClassText.addModifyListener((ModifyListener)this);
        this.uniqueIDText.addModifyListener((ModifyListener)this);
        this.impDateText.addModifyListener((ModifyListener)this);
        this.impVDescrText.addModifyListener((ModifyListener)this);
        this.impVersionText.addModifyListener((ModifyListener)this);
        this.logLevelText.addModifyListener((ModifyListener)this);
        this.roleDateText.addModifyListener((ModifyListener)this);
        this.roleCombo.addSelectionListener((SelectionListener)this);
        this.roleVDescrText.addModifyListener((ModifyListener)this);
        this.roleVersionText.addModifyListener((ModifyListener)this);
        this.browseRef.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ContextTypeItemProvider)this.itemFactory.createContextTypeAdapter();
        this.itemProvider.addListener(this);
    }

    protected void initializeRoleCombo() {
        this.roleCombo.add("Sensor");
        this.roleCombo.add("Extractor");
        this.roleCombo.add("Parser");
        this.roleCombo.add("Formatter");
        this.roleCombo.add("Message Filter");
        this.roleCombo.add("CBE Filter");
        this.roleCombo.add("Outputter");
        this.roleCombo.add("Context");
        this.roleCombo.add("undeclared");
    }

    public void display(EObject object) {
        if (this.currentSelection == object) {
            return;
        }
        if (this.descriptionText.isFocusControl() || this.execClassText.isFocusControl() || this.uniqueIDText.isFocusControl() || this.logLevelText.isFocusControl() || this.impDateText.isFocusControl() || this.impVDescrText.isFocusControl() || this.impVersionText.isFocusControl() || this.nameText.isFocusControl() || this.roleDateText.isFocusControl() || this.roleCombo.isFocusControl() || this.roleVDescrText.isFocusControl() || this.roleVersionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ContextType)object;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.execClassText.setText(this.currentSelection.getExecutableClass() == null ? "" : this.currentSelection.getExecutableClass());
        this.uniqueIDText.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.logLevelText.setText(this.currentSelection.getLoggingLevel() == null ? "" : this.currentSelection.getLoggingLevel());
        this.impDateText.setText(this.currentSelection.getImplementationCreationDate() == null ? "" : this.currentSelection.getImplementationCreationDate().toString());
        this.impVDescrText.setText(this.currentSelection.getImplementationVersionDescription() == null ? "" : this.currentSelection.getImplementationVersionDescription());
        this.impVersionText.setText(this.currentSelection.getImplementationVersion() == null ? "" : this.currentSelection.getImplementationVersion());
        this.roleDateText.setText(this.currentSelection.getRoleCreationDate() == null ? "" : this.currentSelection.getRoleCreationDate().toString());
        this.roleVDescrText.setText(this.currentSelection.getRoleVersionDescription() == null ? "" : this.currentSelection.getRoleVersionDescription());
        this.roleVersionText.setText(this.currentSelection.getRoleVersion() == null ? "" : this.currentSelection.getRoleVersion());
        this.roleCombo.select(this.currentSelection.getRole().getValue());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ContextType)currentSelection;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setExecutableClass(this.execClassText.getText());
        this.currentSelection.setUniqueID(this.uniqueIDText.getText());
        this.currentSelection.setName(this.nameText.getText());
        this.currentSelection.setLoggingLevel(this.logLevelText.getText());
        this.currentSelection.setImplementationCreationDate((Object)this.impDateText.getText());
        this.currentSelection.setImplementationVersion(this.impVersionText.getText());
        this.currentSelection.setImplementationVersionDescription(this.impVDescrText.getText());
        this.currentSelection.setRoleCreationDate((Object)this.roleDateText.getText());
        this.currentSelection.setRoleVersion(this.roleVersionText.getText());
        this.currentSelection.setRoleVersionDescription(this.roleVDescrText.getText());
        this.currentSelection.setRole(ContextRoleNames.get((int)this.roleCombo.getSelectionIndex()));
        return false;
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.descriptionText) {
            String text2 = this.descriptionText.getText();
            if (!text2.equals(this.currentSelection.getDescription())) {
                if (text2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.DESCRIPTION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.execClassText) {
            String text3 = this.execClassText.getText();
            if (!text3.equals(this.currentSelection.getExecutableClass())) {
                if (text3.length() == 0 && this.currentSelection.getExecutableClass() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.EXEC_CLASS);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.uniqueIDText) {
            String text4 = this.uniqueIDText.getText();
            if (!text4.equals(this.currentSelection.getUniqueID())) {
                if (text4.length() == 0 && this.currentSelection.getUniqueID() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.UNIQUE_ID);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text4);
                }
            }
        } else if (e.getSource() == this.nameText) {
            String text5 = this.nameText.getText();
            if (!text5.equals(this.currentSelection.getName())) {
                if (text5.length() == 0 && this.currentSelection.getName() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.NAME);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text5);
                }
            }
        } else if (e.getSource() == this.logLevelText) {
            String text6 = this.logLevelText.getText();
            if (!text6.equals(this.currentSelection.getLoggingLevel())) {
                if (text6.length() == 0 && this.currentSelection.getLoggingLevel() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.LOG_LEVEL);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text6);
                }
            }
        } else if (e.getSource() == this.impDateText) {
            String text7 = this.impDateText.getText();
            if (!text7.equals(this.currentSelection.getImplementationCreationDate())) {
                if (text7.length() == 0 && this.currentSelection.getImplementationCreationDate() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_DATE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text7);
                }
            }
        } else if (e.getSource() == this.impVDescrText) {
            String text8 = this.impVDescrText.getText();
            if (!text8.equals(this.currentSelection.getImplementationVersionDescription())) {
                if (text8.length() == 0 && this.currentSelection.getImplementationVersionDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_DESCR);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text8);
                }
            }
        } else if (e.getSource() == this.impVersionText) {
            String text9 = this.impVersionText.getText();
            if (!text9.equals(this.currentSelection.getImplementationVersion())) {
                if (text9.length() == 0 && this.currentSelection.getImplementationVersion() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.IMPL_VERSION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text9);
                }
            }
        } else if (e.getSource() == this.roleDateText) {
            String text10 = this.roleDateText.getText();
            if (!text10.equals(this.currentSelection.getRoleCreationDate())) {
                if (text10.length() == 0 && this.currentSelection.getRoleCreationDate() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_DATE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text10);
                }
            }
        } else if (e.getSource() == this.roleVDescrText) {
            String text11 = this.roleVDescrText.getText();
            if (!text11.equals(this.currentSelection.getRoleVersionDescription())) {
                if (text11.length() == 0 && this.currentSelection.getRoleVersionDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_DESC);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text11);
                }
            }
        } else if (e.getSource() == this.roleVersionText && !(text = this.roleVersionText.getText()).equals(this.currentSelection.getRoleVersion())) {
            if (text.length() == 0 && this.currentSelection.getRoleVersion() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.ROLE_VERSION);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.roleCombo) {
            int sel = this.roleCombo.getSelectionIndex();
            if (sel != this.currentSelection.getRole().getValue()) {
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextTypeItemProvider.NAME);
                this.currentSelection.setRole(ContextRoleNames.get((int)sel));
                String oldValue = this.currentSelection.getName();
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
                }
            }
        } else if (e.getSource() == this.browseRef) {
            Object sel;
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(Display.getCurrent().getActiveShell(), this.editingDomain);
            dialog.open();
            if (dialog.getReturnCode() == 0 && (sel = dialog.getSelection()) != null) {
                if (sel instanceof SensorConfigType) {
                    this.uniqueIDText.setText(((SensorConfigType)sel).getUniqueID());
                } else if (sel instanceof Extractor) {
                    this.uniqueIDText.setText(((Extractor)sel).getUniqueID());
                } else if (sel instanceof OutputterConfigType) {
                    this.uniqueIDText.setText(((OutputterConfigType)sel).getUniqueID());
                } else if (sel instanceof ContextInstanceType) {
                    this.uniqueIDText.setText(((ContextInstanceType)sel).getUniqueID());
                } else if (sel instanceof ProcessUnitType) {
                    this.uniqueIDText.setText(((ProcessUnitType)sel).getUniqueID());
                } else if (sel instanceof ParserConfigType) {
                    this.uniqueIDText.setText(((ParserConfigType)sel).getUniqueID());
                } else if (sel instanceof FormatterType) {
                    this.uniqueIDText.setText(((FormatterType)sel).getUniqueID());
                } else {
                    this.uniqueIDText.setText("");
                }
            }
        }
    }
}

