/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.PropertyTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertySection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text nameText;
    protected Text valueText;
    protected boolean isDisplaying;
    protected PropertyType currentSelection;
    protected PropertyTypeItemProvider itemProvider;
    protected UnitItemProviderAdapterFactory itemFactory = new UnitItemProviderAdapterFactory();

    public PropertySection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PNAME"), 0);
        this.nameText = factory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PVALUE"), 0);
        this.valueText = factory.createText(this, "", 0);
        this.valueText.setLayoutData((Object)new GridData(768));
        this.valueText.addModifyListener((ModifyListener)this);
        this.nameText.addModifyListener((ModifyListener)this);
        this.itemProvider = (PropertyTypeItemProvider)this.itemFactory.createPropertyTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (object != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer().eContainer());
        }
        if (this.currentSelection == object) {
            return;
        }
        if (this.valueText.isFocusControl() || this.nameText.isFocusControl()) {
            return;
        }
        this.currentSelection = (PropertyType)object;
        this.isDisplaying = true;
        this.valueText.setText(this.currentSelection.getPropertyValue() == null ? "" : this.currentSelection.getPropertyValue());
        this.nameText.setText(this.currentSelection.getPropertyName() == null ? "" : this.currentSelection.getPropertyName());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (PropertyType)currentSelection;
        this.currentSelection.setPropertyName(this.nameText.getText());
        this.currentSelection.setPropertyValue(this.valueText.getText());
        return false;
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.valueText) {
            String text2 = this.valueText.getText();
            if (!text2.equals(this.currentSelection.getPropertyValue())) {
                if (text2.length() == 0 && this.currentSelection.getPropertyValue() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, PropertyTypeItemProvider.VALUE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.nameText && !(text = this.nameText.getText()).equals(this.currentSelection.getPropertyName())) {
            if (text.length() == 0 && this.currentSelection.getPropertyName() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, PropertyTypeItemProvider.NAME);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

