/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logc.internal.extensions;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ICorrelationMonitor;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;

public class TimeBasedLogRecordCorrelationEngineImpl
implements ILogRecordCorrelationEngine {
    String correlationName;
    CorrelationEngine correlationEngine;
    CorrelationContainer correlationContainer;

    public void correlate(CorrelationContainerProxy correlationContainerProxy, EList list, ICorrelationMonitor monitor) {
        this.correlationEngine = correlationContainerProxy.getCorrelationEngine();
        this.correlationContainer = correlationContainerProxy.getCorrelationContainer();
        if (this.correlationEngine == null) {
            this.correlationName = LogCorrelatorPlugin.getResourceString("CORR_NAME");
            this.correlationEngine.setType(LogCorrelatorPlugin.getResourceString("CORR_TYPE"));
            this.correlationEngine.setName(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
            this.correlationEngine.setId(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
        }
        int total = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            EList recordList = ((RecordList)((Object)list.get(i))).getList();
            total += recordList.size();
        }
        int count = 0;
        monitor.beginTask(correlationContainerProxy.getCorrelationEngine().getName(), total);
        String[] msg = new String[]{"0", String.valueOf(total)};
        try {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                EList recordList = ((RecordList)((Object)list.get(i))).getList();
                for (int k = 0; k < recordList.size(); ++k) {
                    if (recordList.get(k) == null) continue;
                    if (monitor != null) {
                        msg[0] = String.valueOf(++count);
                        monitor.worked(1);
                        monitor.subTask(LogCorrelatorPlugin.getResourceString("STR_PROCESSING_MSG", msg));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    this.setPartners(recordList.get(k), list, i, k, monitor, msg);
                }
            }
        }
        catch (OperationCanceledException e) {
            // empty catch block
        }
        monitor.done();
    }

    private void setPartners(Object art, EList list, int currentListIndex, int currentRecordIndex, ICorrelationMonitor monitor, String[] msg) {
        CBECommonBaseEvent artifact = (CBECommonBaseEvent)art;
        double artifactTime = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)artifact);
        EList recordList = null;
        for (int i = 0; i < list.size(); ++i) {
            if (i < currentListIndex || (recordList = ((RecordList)((Object)list.get(i))).getList()) == null) continue;
            for (int k = 0; k < recordList.size(); ++k) {
                if (recordList.get(k) == null || i <= currentListIndex && (i != currentListIndex || k <= currentRecordIndex) || CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)recordList.get(k))) != artifactTime || recordList.get(k) == art) continue;
                this.addCorrelation((CBECommonBaseEvent)art, (CBECommonBaseEvent)recordList.get(k));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EList addCorrelation(CBECommonBaseEvent artifact, CBECommonBaseEvent associatedEvent) {
        EMap correlationMap = this.correlationContainer.getCorrelations();
        EList correlations = null;
        EMap eMap = correlationMap;
        synchronized (eMap) {
            correlations = (EList)correlationMap.get((Object)artifact);
            if (correlations == null) {
                correlations = new BasicEList();
                correlations.add((Object)associatedEvent);
                this.correlationContainer.getCorrelations().put((Object)artifact, (Object)correlations);
            } else {
                correlations.add((Object)associatedEvent);
            }
        }
        return correlations;
    }
}

