/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core.internal;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public class EllipsisisMessage
extends AsyncMessage
implements ITimeRange {
    public int getX() {
        if (this.startLifeline == null) {
            return super.getX() + super.getWidth() - 16;
        }
        return super.getX();
    }

    public int getWidth() {
        return 16;
    }

    private void drawMessage(IGC context) {
        int x = super.getX();
        int y = this.getY();
        int width = super.getWidth();
        int height = this.getHeight();
        if (this.startLifeline == null && this.endLifeline != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawLine(x + width - 5, y, x + width - 6, y + height);
            context.drawLine(x + width - 10, y, x + width - 11, y + height);
            context.drawLine(x + width - 15, y, x + width - 16, y + height);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.setBackground(storedColor);
        } else if (this.endLifeline == null && this.startLifeline != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawLine(x + 5, y, x + 6, y + height);
            context.drawLine(x + 10, y, x + 11, y + height);
            context.drawLine(x + 15, y, x + 16, y + height);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.setBackground(storedColor);
        } else {
            super.draw(context);
        }
    }

    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS"));
        }
        context.setLineWidth(1);
        this.drawMessage(context);
    }
}

