/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WarningDialog
extends Dialog
implements SelectionListener {
    private String _title;
    private Button _showAgain;
    private String text;
    private String message;
    private String tipPreferenceId;

    public WarningDialog(Shell shell, String windowTitle, String message, String text, String tipPreferenceId) {
        super(shell);
        this.message = message;
        this.text = text;
        this.tipPreferenceId = tipPreferenceId;
        this._title = windowTitle;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        Image image = JFaceResources.getImageRegistry().get("dialog_info_imageg");
        if (image != null) {
            Label label = new Label(result, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        Label warningMessage = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        warningMessage.setLayoutData((Object)data);
        warningMessage.setText(this.message);
        warningMessage = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        warningMessage.setLayoutData((Object)data);
        this._showAgain = new Button(result, 32);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        this._showAgain.setLayoutData((Object)data);
        this._showAgain.setText(this.text);
        this._showAgain.addSelectionListener((SelectionListener)this);
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._showAgain) {
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            store.setValue(this.tipPreferenceId, !this._showAgain.getSelection());
        }
    }
}

