/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportTracePage1
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    protected Button sourceBrowseButton;
    protected ImportTraceRange _option;
    protected String fError;
    protected String fInputLog = "";
    protected TRCMonitor fMonitor;
    protected Text sourceNameField;
    protected TraceLocationUI _location;
    protected double fStartPercentage;
    protected double fStopPercentage;
    private Button _showExecFlow;
    private Button _showExecStatistic;
    private Button _showHeapStatistic;
    private Composite _detailsGroup;
    private Label _description;
    private Shell shell;
    private long logLength;
    private int collectionMode = 0;

    public ImportTracePage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(UIPlugin.getResourceString("IMPORT_XML_TRACE_PTITLE"));
        this.setDescription(UIPlugin.getResourceString("IMPORT_XML_TRACE_PDESC"));
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("launch_wiz.gif"));
        this.shell = aWorkbench.getActiveWorkbenchWindow().getShell();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, UIPlugin.getResourceString("STR_IMPORT_XML_PSOURCEQ"));
        this._location = new TraceLocationUI();
        this._location.createControl(composite);
        this._location.getLocationLabel().setText(UIPlugin.getResourceString("STR_IMPORT_FOLDER"));
        this.createSpacer(composite);
        this._option = new ImportTraceRange((WizardPage)this);
        this._option.createControl(composite);
        this.addStatisticOption(composite);
        this.createSpacer(composite);
        this._option.getWholeFileBtn().addSelectionListener((SelectionListener)this);
        this._option.getInRangeBtn().addSelectionListener((SelectionListener)this);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
        PDProjectExplorer projectExplorer = null;
        PDProjectViewer projectViewer = null;
        IWorkbenchPage page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            projectExplorer = UIPlugin.getDefault().getViewer();
        }
        IProject selectionProject = null;
        TRCMonitor selectionMonitor = null;
        if (projectExplorer != null) {
            projectViewer = (PDProjectViewer)projectExplorer.getViewer();
        }
        if (projectViewer != null) {
            selectionProject = projectViewer.getSelectionProject();
            selectionMonitor = projectViewer.getSelectionMonitor();
        }
        this._location.getLocation().addModifyListener((ModifyListener)this);
        this._location.getMonitor().addModifyListener((ModifyListener)this);
        this.sourceNameField.addModifyListener((ModifyListener)this);
        if (selectionProject != null) {
            this._location.setLocation(selectionProject.getName());
        }
        if (selectionMonitor != null) {
            this._location.setMonitor(selectionMonitor.getName());
        }
    }

    public boolean finish() {
        this.fInputLog = this.sourceNameField.getText().trim();
        File log = new File(this.sourceNameField.getText().trim());
        if (!log.exists()) {
            this.fError = UIPlugin.getResourceString("STR_ERROR_XML_NOTFOUND");
            this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
            String errMsg = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)errMsg, (IStatus)err1);
            return false;
        }
        if (!log.canRead()) {
            this.fError = UIPlugin.getResourceString("STR_ERROR_XML_READFILE");
            this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
            String errMsg = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)errMsg, (IStatus)err1);
            return false;
        }
        this.fError = null;
        if (this._option.getInRangeSelection()) {
            this.fStartPercentage = this._option.getStartRange();
            this.fStopPercentage = this._option.getStopRange();
        } else {
            this.fStartPercentage = 0.0;
            this.fStopPercentage = 100.0;
        }
        return this.loadXMLTrace();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor mon) {
        Display d = Display.getDefault();
        d.syncExec(new Runnable(){

            public void run() {
                if (ImportTracePage1.this._showHeapStatistic.getSelection()) {
                    ImportTracePage1.this.collectionMode = 0;
                } else if (ImportTracePage1.this._showExecStatistic.getSelection()) {
                    ImportTracePage1.this.collectionMode = 3;
                } else if (ImportTracePage1.this._showExecFlow.getSelection()) {
                    ImportTracePage1.this.collectionMode = 2;
                }
            }
        });
        try {
            File log = new File(this.fInputLog);
            if (!PDCoreUtil.isZipFile(this.fInputLog)) {
                BufferedInputStream readStream = new BufferedInputStream(new FileInputStream(log));
                this.logLength = log.length();
                XMLLoader processor = new XMLLoader(this.fMonitor);
                processor.setCollectionMode(this.collectionMode);
                this.importFile(mon, processor, log, readStream);
            } else {
                ZipFile zf = new ZipFile(log);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                boolean iter = false;
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    this.logLength = zipEntry.getSize();
                    XMLLoader processor = new XMLLoader(this.fMonitor);
                    processor.setCollectionMode(this.collectionMode);
                    this.importFile(mon, processor, log, zf.getInputStream(zipEntry));
                }
            }
        }
        catch (IOException e) {
            this.fError = UIPlugin.getResourceString("STR_IMPORT_IOEXCEPTION_ERROR_");
            this.fError = HyadesUtil.change(this.fError, "%1", e.getMessage());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._showExecStatistic) {
            this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
        } else if (e.widget == this._showHeapStatistic) {
            this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        } else if (e.widget == this._showExecFlow) {
            this._description.setText(UIPlugin.getResourceString("Show Execution flow graphical details."));
        } else {
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        data.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)data);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        return button;
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(UIPlugin.getResourceString("STR_IMPORT_XML_SOURCE"));
        this.sourceNameField = new Text(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(UIPlugin.getResourceString("BROWSE"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".xmli0000"));
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        FileDialog dlg = new FileDialog(this.sourceNameField.getShell());
        dlg.setFilterPath(currentSource);
        dlg.setFilterExtensions(new String[]{"*.trcxml", "*.*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            this.sourceNameField.setText(dlg.getFilterPath() + File.separator + fileName);
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getLocation().getText().trim().equals("") && !this._location.getMonitor().getText().trim().equals("") && (this._option.getWholeFileSelection() || this._option.getInRangeSelection() && this._option.checkRegionValue() == null);
    }

    protected boolean validateSourceGroup() {
        return !this.sourceNameField.getText().trim().equals("");
    }

    private void addStatisticOption(Composite parent) {
        Group _showExecGroup = new Group(parent, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        _showExecGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        _showExecGroup.setLayout((Layout)layout);
        this._showHeapStatistic = new Button((Composite)_showExecGroup, 16);
        this._showHeapStatistic.setText(UIPlugin.getResourceString("HEAP_STAT"));
        this._showExecStatistic = new Button((Composite)_showExecGroup, 16);
        this._showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
        this._showExecFlow = new Button((Composite)_showExecGroup, 16);
        this._showExecFlow.setText(UIPlugin.getResourceString("FULL_DATA"));
        this._description = new Label(parent, 64);
        data = new GridData();
        data.horizontalIndent = 20;
        data.widthHint = 375;
        this._description.setLayoutData((Object)data);
        this._description.setLayoutData((Object)data);
        this._description.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
        this._showHeapStatistic.setSelection(true);
        this._showHeapStatistic.addSelectionListener((SelectionListener)this);
        this._showExecStatistic.addSelectionListener((SelectionListener)this);
        this._showExecFlow.addSelectionListener((SelectionListener)this);
    }

    private String createModel(TRCMonitor monitor, String inputLog) {
        this.fMonitor = monitor;
        this.fInputLog = inputLog;
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return e.getTargetException().getMessage();
        }
        return this.fError;
    }

    private void handleOutOfMemoryError() {
        String text = UIPlugin.getResourceString("IMPORT_OUT_OF_MEMORY_ERROR_");
        if (this.shell != null) {
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)ImportTracePage1.this.shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("OUT_OF_MEMORY_ERROR_TITLE"), (IStatus)err);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFile(IProgressMonitor mon, XMLLoader processor, File log, InputStream readStream) throws OutOfMemoryError {
        try {
            block36: {
                block33: {
                    block32: {
                        block31: {
                            block29: {
                                block30: {
                                    cancelOperation = false;
                                    l = 1;
                                    lastValidLine = 1;
                                    try {
                                        done = false;
                                        bufferSize = bSize = 65536;
                                        buffer = new byte[bufferSize];
                                        forwardBuffer = new byte[bufferSize];
                                        position = 0L;
                                        bytesRead = 0;
                                        startLength = this.logLength / 100L;
                                        startLength *= this.fStartPercentage;
                                        endLength = this.logLength;
                                        if (this.fStopPercentage != 100.0) {
                                            endLength /= 100.0;
                                            endLength *= this.fStopPercentage;
                                        }
                                        mon.beginTask(this.fInputLog, (int)(endLength - startLength));
                                        forwardOffset = 0;
                                        offset = 0;
lbl21:
                                        // 2 sources

                                        while (bytesRead > -1) {
                                            if (mon.isCanceled()) {
                                                readStream.close();
                                                cancelOperation = true;
                                                throw new OperationCanceledException();
                                            }
                                            offset = 0;
                                            bytesRead = readStream.read(buffer);
lbl28:
                                            // 5 sources

                                            while (offset < bytesRead) {
                                                forwardBuffer[forwardOffset++] = buffer[offset];
                                                if (forwardOffset == bufferSize) {
                                                    tempForwardBuffer = forwardBuffer;
                                                    forwardBuffer = new byte[bufferSize += bSize];
                                                    System.arraycopy(tempForwardBuffer, 0, forwardBuffer, 0, forwardOffset);
                                                    continue;
                                                }
                                                if (buffer[offset++] != 10) continue;
                                                ++l;
                                                if (forwardBuffer[1] == 63) break block29;
                                                try {
                                                    position += (long)forwardOffset;
                                                    if ((double)position > endLength && endLength != (double)log.length()) {
                                                        end = new String("</TRACE>").getBytes();
                                                        processor.loadEvent(end, 8, true);
                                                        mon.done();
                                                        readStream.close();
                                                        break block30;
                                                    }
                                                    ** GOTO lbl-1000
                                                }
                                                catch (InvalidXMLException e) {
                                                    mon.worked(forwardOffset);
                                                    readStream.close();
                                                    position -= (long)forwardOffset;
                                                }
                                                catch (OutOfMemoryError me) {
                                                    readStream.close();
                                                    this.handleOutOfMemoryError();
                                                    throw me;
                                                }
                                            }
                                            break block31;
                                        }
                                        break block32;
                                    }
                                    catch (IOException e) {
                                        this.fError = UIPlugin.getResourceString("STR_IMPORT_IOEXCEPTION_ERROR_");
                                        this.fError = HyadesUtil.change(this.fError, "%1", e.getMessage());
                                        break block33;
                                    }
                                    catch (Exception e) {
                                        this.fError = cancelOperation != false ? "" : UIPlugin.getResourceString("STR_IMPORT_EXCEPTION_ERROR_");
                                        this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
                                        this.fError = HyadesUtil.change(this.fError, "%2", String.valueOf(lastValidLine));
                                        this.fError = HyadesUtil.change(this.fError, "%3", e.getMessage());
                                        break block33;
                                    }
                                }
                                var24_27 = null;
                                if (readStream != null) {
                                    processor.cleanUp();
                                    try {
                                        readStream.close();
                                    }
                                    catch (IOException ioexc) {
                                        // empty catch block
                                    }
                                }
                                mon.done();
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    loadToModel = this.loadLine(l, position, startLength, endLength);
                                    processor.loadEvent(forwardBuffer, forwardOffset, loadToModel);
                                }
                            }
                            lastValidLine = l;
                            mon.worked(forwardOffset);
                            forwardOffset = 0;
                            ** GOTO lbl28
                        }
                        this.fError = null;
                        ** GOTO lbl21
                    }
                    if (lastValidLine != l) {
                        block35: {
                            readStream.close();
                            this.fError = UIPlugin.getResourceString("STR_EOF_REACHED_ERROR_");
                            this.fError = HyadesUtil.change(this.fError, "%1", this.fInputLog);
                            this.fError = HyadesUtil.change(this.fError, "%2", String.valueOf(lastValidLine));
                            var24_28 = null;
                            if (readStream != null) {
                                processor.cleanUp();
                                ** try [egrp 6[TRYBLOCK] [13 : 620->628)] { 
lbl101:
                                // 1 sources

                                readStream.close();
                                break block35;
lbl103:
                                // 1 sources

                                catch (IOException ioexc) {
                                    // empty catch block
                                }
                            }
                        }
                        mon.done();
                        return;
                    }
                }
                if (readStream != null) {
                    try {
                        readStream.close();
                    }
                    catch (IOException ioexc) {
                        // empty catch block
                    }
                }
                mon.done();
                var24_29 = null;
                if (readStream != null) {
                    processor.cleanUp();
                    ** try [egrp 6[TRYBLOCK] [13 : 620->628)] { 
lbl121:
                    // 1 sources

                    readStream.close();
                    break block36;
lbl123:
                    // 1 sources

                    catch (IOException ioexc) {
                        // empty catch block
                    }
                }
            }
            mon.done();
            return;
        }
        catch (Throwable var23_35) {
            block37: {
                var24_30 = null;
                if (readStream != null) {
                    processor.cleanUp();
                    ** try [egrp 6[TRYBLOCK] [13 : 620->628)] { 
lbl134:
                    // 1 sources

                    readStream.close();
                    break block37;
lbl136:
                    // 1 sources

                    catch (IOException ioexc) {
                        // empty catch block
                    }
                }
            }
            mon.done();
            throw var23_35;
        }
    }

    private boolean loadLine(int line, double position, double startLength, double endLength) {
        if (line <= 7) {
            return true;
        }
        return position >= startLength && position <= endLength;
    }

    private boolean loadXMLTrace() {
        IWorkbenchPage page = UIPlugin.getActivePage();
        if (page == null) {
            return false;
        }
        IContainer res = PDCoreUtil.createContainer((IPath)new Path(this._location.getLocation().getText().trim()));
        if (res == null) {
            return false;
        }
        TRCMonitor mon = PDCoreUtil.createMonitor(res, this._location.getMonitor().getText().trim());
        this.fError = this.createModel(mon, this.sourceNameField.getText().trim());
        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource(null);
        event.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        if (this.fError != null) {
            if (!this.fError.equals("")) {
                String errMsg = UIPlugin.getResourceString("STR_ERROR_LOAD_XML");
                Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)errMsg, (IStatus)err1);
            }
            return false;
        }
        return true;
    }

    public void setTraceFile(String fullPath) {
        this.sourceNameField.setText(fullPath);
    }

    static final class FileInfo {
        InputStream inputStream;
        long fileLength;

        FileInfo() {
        }
    }
}

