/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizardPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenNodeWizardPage
extends NewNodeWizardPage
implements ModifyListener {
    public OpenNodeWizardPage(String name) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
        this.setDescription(UIPlugin.getResourceString("NODE_PROPERTIES_DESC"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this._nodeUI.setEnabled(false);
        this.populateData();
        this.setPageComplete(true);
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".onwp0000"));
    }

    public boolean finish() {
        TRCNode node = ((OpenNodeWizard)this.getWizard()).getNode();
        if (node == null) {
            return true;
        }
        if (node.getDeltaTime() != this._nodeUI.getDeltaTime()) {
            node.setDeltaTime(this._nodeUI.getDeltaTime());
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(node);
            event.setType(2048);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        return true;
    }

    public void modifyText(ModifyEvent event) {
        this.setPageComplete(true);
        String port = this._nodeUI.getPortNumberUI().getText().trim();
        if (event.widget == this._nodeUI.getPortNumberUI()) {
            try {
                int value = Integer.parseInt(port);
                if (value < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getHourUI()) {
            try {
                int hourValue = Integer.parseInt(this._nodeUI.getHourUI().getText().trim());
                if (hourValue < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getHourUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getMinUI()) {
            try {
                int minValue = Integer.parseInt(this._nodeUI.getMinUI().getText().trim());
                if (minValue < 0 || minValue > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getMinUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getSecUI()) {
            try {
                int secValue = Integer.parseInt(this._nodeUI.getSecUI().getText().trim());
                if (secValue < 0 || secValue > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getMicSecUI()) {
            try {
                int micsecValue = Integer.parseInt(this._nodeUI.getMicSecUI().getText().trim());
                if (micsecValue < 0 || micsecValue > 1000000) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        }
    }

    protected void populateData() {
        TRCNode node = ((OpenNodeWizard)this.getWizard()).getNode();
        if (node == null) {
            return;
        }
        this._nodeUI.getNodeNameUI().setText(node.getName());
        this._nodeUI.getPortNumberUI().setText(String.valueOf(node.getPort()));
        if (node.getIpAddress() != null) {
            this._nodeUI.getAddressUI().setText(node.getIpAddress());
        }
        this._locationUI.setMonitor(node.getMonitor().getName());
        double delta = node.getDeltaTime();
        if (delta != 0.0) {
            this._nodeUI.setDeltaTime(delta);
        }
    }
}

