/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenLogView
implements IObjectActionDelegate {
    private SDView view;
    private CorrelationContainerProxy proxy;
    private EObject cbeEvent;

    public void run(IAction action) {
        this.openView();
    }

    private void openView() {
        try {
            LogViewer view;
            IWorkbenchPage persp = UIPlugin.getActivePage();
            EObject mofObject = HyadesUtil.getObjectToView((EObject)HyadesUtil.getMofObject());
            if (mofObject == null) {
                this.selectCorrelationProxyInNavigator();
                mofObject = this.proxy;
            }
            if ((view = (LogViewer)persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer")) != null) {
                view.addViewPage(mofObject);
                view.getLogPage().getView().revealObject(this.cbeEvent);
                LogUtil.notifyViewSelectionChanged((Object)view.getLogPage().getView(), (Object)this.cbeEvent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && ((IStructuredSelection)selection).getFirstElement() instanceof LogGraphNode) {
            LogGraphNode sel = (LogGraphNode)((Object)((IStructuredSelection)selection).getFirstElement());
            if (sel != null) {
                this.cbeEvent = sel.hasElements() ? (EObject)sel.getElements().get(0) : sel.getElement();
            }
        } else {
            this.cbeEvent = null;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null && targetPart instanceof SDView) {
            LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
            this.proxy = loader.getCorrelationContainerProxy();
        } else {
            this.proxy = null;
        }
    }

    public void selectCorrelationProxyInNavigator() {
        if (this.proxy != null) {
            LogUtil.selectInLogNavigator((EObject)this.proxy);
            if (this.cbeEvent != null) {
                UIPlugin.getDefault().getSelectionModel((EObject)this.proxy).add((Object)this.cbeEvent);
            }
        }
    }
}

