/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.FiltersDialog;
import org.eclipse.hyades.log.ui.internal.util.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.util.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.LogRecordSearch;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SearchRecordDialog;
import org.eclipse.hyades.log.ui.internal.util.SortElement;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncReturnMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogInteractions
implements IUml2SDLoader,
ISelectionListener,
ISelectionChangedListener,
IViewSelectionChangedListener,
ISDAdvancedPagingProvider,
ILogInteractionsPreferenceListener,
IExtendedFilterProvider,
IExtendedFindProvider,
ILogFilterProvider,
ILogFindProvider,
IProfileEventListener,
IJobChangeListener {
    protected CorrelationContainerProxy correlationContainerProxy;
    protected EObject inputObject;
    protected Map graphNodes = new HashMap();
    protected Map lifelinesMap = new HashMap();
    protected List eventsList = new ArrayList();
    protected Map eventsMap = new HashMap();
    protected Map currentPageEvents = new HashMap();
    protected List agentsList = new ArrayList();
    protected SDView view;
    private Map sourceOutOfPageMessages;
    private Map targetOutOfPageMessages;
    private Map dummyMessages;
    private IConfigurationElement correlationType;
    private LogRecordComparator comparator;
    private CBECommonBaseEvent currentSelection;
    private CBECommonBaseEvent thisSelection;
    private SearchRecordDialog dialog;
    private LogFilterCriteria criteria = null;
    private boolean isInputXMI = true;
    private SimpleSearchQuery query = null;
    private QueryResult outBoundCorrelations = null;
    private QueryResult inboundCorrelations = null;
    private final int TIME_CONVERSION_FACTOR = 1000000;
    private int currentPageIndex = 0;
    private int nrOfPages = 0;
    private int PAGE_SIZE = 0;
    private int MAX_NR_OF_RECORDS = 99999;
    private int totalSize = 0;
    private final int NODE_SIZE = 24;
    private IFilterElement[] filterTableElements = null;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private boolean displayOnlyCorrelations = true;
    private Object[] pageCache;
    private LogRecordSearch logRecordSearch = null;
    protected List expandedList = new ArrayList();
    protected LogInteractionsFrame frame;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[1];
    protected static IImage image;
    public static final int CATEGORY_LOGS = 0;
    private boolean debug = false;

    public LogInteractions() {
        UIPlugin.getDefault().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        CorrelationHelper.getInstance().addJobChangeListener((IJobChangeListener)this);
        this.recordFilterSearch = new RecordFilterSearchUtil();
    }

    public void setViewer(SDView view) {
        this.view = view;
        view.setSDPagingProvider((ISDPagingProvider)this);
        view.setExtendedFilterProvider((IExtendedFilterProvider)this);
        view.setExtendedFindProvider((IExtendedFindProvider)this);
        view.getSDWidget().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        view.getSite().setSelectionProvider(view.getSDWidget().getSelectionProvider());
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
    }

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        CorrelationHelper.getInstance().removeJobChangeListener((IJobChangeListener)this);
        if (this.view != null) {
            this.view.getSDWidget().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.clearDiagramCaches();
        this.recordFilterSearch = null;
    }

    public void generateLogInteractions(EObject eObject, boolean displayDialog) {
        this.view.setFrame((Frame)this.parseModel(eObject, displayDialog, false));
        this.disableMessageActions();
    }

    public void generateLogInteractions(EObject eObject, IConfigurationElement config) {
        this.setCorrelationType(config);
        this.view.setFrame((Frame)this.parseModel((EObject)CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)eObject, this.correlationType.getAttribute("name")), false, false));
        this.disableMessageActions();
    }

    public LogInteractionsFrame parseModel(EObject eObject, final boolean displayDialog, final boolean refresh) {
        this.inputObject = eObject;
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        this.displayOnlyCorrelations = store.getString("pd_filter_show_correlation_only").equals("1");
        this.correlationContainerProxy = null;
        this.clearDiagramCaches();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.loadCorrelations(displayDialog);
                LogInteractions.this.createPartition();
                LogInteractions.this.frame = LogInteractions.this.createPage(refresh);
            }
        });
        return this.frame;
    }

    public LogInteractionsFrame parseModel(EObject eObject) {
        return this.parseModel(eObject, false, false);
    }

    protected void refresh() {
        if (this.inputObject != null) {
            this.view.setFrame((Frame)this.parseModel(this.inputObject, false, true));
        } else {
            this.view.setFrame(new Frame());
        }
    }

    protected List getFilteredEventsXMI(List input) {
        if (input == null) {
            return new ArrayList(0);
        }
        ArrayList filteredList = new ArrayList();
        for (int i = 0; i < input.size(); ++i) {
            Object entry = input.get(i);
            if (!this.isFilterApplied((EObject)entry)) continue;
            filteredList.add(entry);
        }
        Collections.sort(filteredList, this.getComparator());
        return filteredList;
    }

    private boolean isFilterApplied(EObject event) {
        if (this.filterTableElements == null || this.filterTableElements.length == 0) {
            return true;
        }
        return this.recordFilterSearch.isAdvFilterApply(event, this.filterTableElements);
    }

    protected void clearTemporaryCaches() {
        this.graphNodes.clear();
        this.lifelinesMap.clear();
        this.currentPageEvents.clear();
        if (this.sourceOutOfPageMessages != null) {
            this.sourceOutOfPageMessages.clear();
        }
        if (this.targetOutOfPageMessages != null) {
            this.targetOutOfPageMessages.clear();
        }
        if (this.dummyMessages != null) {
            this.dummyMessages.clear();
        }
    }

    protected void clearDiagramCaches() {
        this.clearTemporaryCaches();
        this.agentsList.clear();
        this.eventsMap.clear();
        if (this.eventsList != null) {
            this.eventsList.clear();
            this.eventsList = null;
            this.eventsList = new ArrayList(0);
        }
        if (this.pageCache != null) {
            for (int i = 0; i < this.pageCache.length; ++i) {
                this.pageCache[i] = null;
            }
            this.pageCache = null;
        }
        this.expandedList.clear();
    }

    protected void loadCorrelations(boolean displayDialog) {
        if (this.inputObject instanceof CorrelationContainerProxy) {
            this.correlationContainerProxy = (CorrelationContainerProxy)this.inputObject;
        } else if (displayDialog) {
            this.showCorrelationDialog();
        }
        this.loadAgents();
        this.setInputType();
        if (this.isInputXMI()) {
            this.loadEventsXMI();
            this.eventsList = this.getFilteredEventsXMI(this.eventsList);
        } else {
            this.loadEventsSQL();
        }
    }

    private void loadAgents() {
        if (this.correlationContainerProxy != null) {
            this.agentsList.addAll(this.correlationContainerProxy.getCorrelatedAgents());
        } else {
            this.agentsList.addAll(HyadesUtil.getLogAgents((EObject)this.inputObject));
        }
    }

    private List getFilteredEventsSQL() {
        this.query = (SimpleSearchQuery)LogQueryBuilder.createQuery((List)this.agentsList, (ILogFilterCriteria)this.getFilterCriteria());
        QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
        if (queryResult == null) {
            return new ArrayList(0);
        }
        ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
        return resultEntry.getObjects();
    }

    protected void loadEventsSQL() {
        Iterator iter = this.agentsList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy element = (TRCAgentProxy)iter.next();
            element.getAgent();
        }
        if (!this.displayOnlyCorrelations) {
            this.eventsList = this.getFilteredEventsSQL();
        } else {
            this.loadEventsFromCorrelationsSQL();
        }
    }

    protected void loadEventsFromCorrelationsSQL() {
        if (this.correlationContainerProxy == null) {
            this.eventsList = new ArrayList(0);
            return;
        }
        try {
            CorrelationContainer correlationContainer = (CorrelationContainer)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false);
            if (correlationContainer == null) {
                return;
            }
            URI correlationContainerURI = EcoreUtil.getURI((EObject)correlationContainer);
            this.query = (SimpleSearchQuery)LogQueryBuilder.createCorrelatedEventsQuery((List)this.agentsList);
            ((TimeBasedCorrelationQuery)this.query).setCorrelationContainerURI(correlationContainerURI.toString());
            this.query = (SimpleSearchQuery)LogQueryBuilder.getMergedQuery((Query)this.query, (ILogFilterCriteria)this.getFilterCriteria());
            QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
            if (queryResult != null) {
                ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
                this.eventsList = resultEntry.getObjects();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            this.eventsList = new ArrayList(0);
        }
    }

    private void addEventsSQL() {
    }

    private void setInputType() {
        int s = this.agentsList.size();
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        for (int i = 0; i < s; ++i) {
            proxy = (TRCAgentProxy)this.agentsList.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent == null || !EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) continue;
            this.isInputXMI = true;
            return;
        }
        if (this.correlationContainerProxy != null && this.correlationContainerProxy.getCorrelationEngine().getName().equals(LogCorrelatorPlugin.getResourceString((String)"CORR_NAME"))) {
            this.isInputXMI = false;
            return;
        }
        this.isInputXMI = true;
    }

    public boolean isInputXMI() {
        return this.isInputXMI;
    }

    protected void loadEventsXMI() {
        if (!this.displayOnlyCorrelations) {
            Iterator iter = this.agentsList.iterator();
            while (iter.hasNext()) {
                TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
                if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
                this.addEvents(trcAgentProxy);
            }
        } else {
            this.loadEventsFromCorrelationsXMI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEventsFromCorrelationsXMI() {
        EMap correlations;
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap eMap = correlations = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        synchronized (eMap) {
            Iterator iter = correlations.iterator();
            while (iter.hasNext()) {
                CorrelationEntryImpl element = (CorrelationEntryImpl)iter.next();
                this.eventsMap.put(element.getKey(), "");
                List targetList = (List)element.getValue();
                if (targetList == null || targetList.size() <= 0) continue;
                int s = targetList.size();
                for (int i = 0; i < s; ++i) {
                    this.eventsMap.put(targetList.get(i), "");
                }
            }
        }
        if (!this.eventsMap.isEmpty()) {
            this.eventsList.addAll(this.eventsMap.keySet());
        }
        this.eventsMap.clear();
    }

    protected Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new LogRecordComparator();
        }
        return this.comparator;
    }

    protected void generateDiagram(final boolean refresh) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.generateGraphNodes();
                if (LogInteractions.this.isInputXMI()) {
                    LogInteractions.this.generateGraphConnectionsXMI();
                } else {
                    LogInteractions.this.generateGraphConnectionsSQL(refresh);
                }
            }
        });
    }

    private void generateGraphConnectionsSQL(boolean refresh) {
        block28: {
            int i;
            int index;
            int s;
            List currentPageList;
            CBECommonBaseEvent target;
            CBECommonBaseEvent source;
            EList valuesList;
            EList keysList;
            ResultEntry resultEntry;
            block27: {
                URI correlationContainerURI;
                block26: {
                    block25: {
                        if (this.correlationContainerProxy == null) {
                            return;
                        }
                        CorrelationContainer correlationContainer = (CorrelationContainer)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false);
                        if (correlationContainer == null) {
                            return;
                        }
                        correlationContainerURI = EcoreUtil.getURI((EObject)correlationContainer);
                        try {
                            if (this.outBoundCorrelations == null || refresh) {
                                Query outBoundCorrelationsQuery = LogQueryBuilder.createOutboundCorrelationQuery((List)this.agentsList, (ILogFilterCriteria)this.getFilterCriteria());
                                ((TimeBasedCorrelationQuery)outBoundCorrelationsQuery).setCorrelationContainerURI(correlationContainerURI.toString());
                                this.outBoundCorrelations = LogQueryBuilder.executeQuery((Query)outBoundCorrelationsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                            }
                        }
                        catch (Exception e) {
                            if (!this.debug) break block25;
                            e.printStackTrace();
                        }
                    }
                    resultEntry = null;
                    keysList = null;
                    valuesList = null;
                    source = null;
                    target = null;
                    currentPageList = this.getCurrentPageEventsList();
                    s = currentPageList.size();
                    index = -1;
                    if (this.outBoundCorrelations != null) {
                        int i2;
                        resultEntry = (ResultEntry)this.outBoundCorrelations.getResultEntries().get(0);
                        keysList = resultEntry.getObjects();
                        resultEntry = (ResultEntry)this.outBoundCorrelations.getResultEntries().get(1);
                        valuesList = resultEntry.getObjects();
                        for (i2 = 0; i2 < s && (index = keysList.indexOf(source = (CBECommonBaseEvent)currentPageList.get(i2))) < 0; ++i2) {
                        }
                        if (this.debug) {
                            System.out.println("Index outbound = " + index);
                            System.out.println("keysList size = " + keysList.size());
                            System.out.println("keysList size = " + valuesList.size());
                        }
                        i2 = 0;
                        try {
                            if (index <= -1) break block26;
                            s = keysList.size();
                            for (i2 = index; i2 < s; ++i2) {
                                source = (CBECommonBaseEvent)keysList.get(i2);
                                target = (CBECommonBaseEvent)valuesList.get(i2);
                                if (this.currentPageEvents.get(source) != null) {
                                    if (this.currentPageEvents.get(target) != null) {
                                        if (this.inExpandedList(source) && source != this.thisSelection && target != this.thisSelection) {
                                            this.createDummyMessage(source);
                                            continue;
                                        }
                                        this.createAsyncMessage(source, target);
                                        continue;
                                    }
                                    if (!this.inExpandedList(source) || source == this.thisSelection) {
                                        this.createTargetOutOfPageMessage(source, target);
                                        continue;
                                    }
                                    this.createDummyMessage(source);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (!this.debug) break block26;
                            e.printStackTrace();
                            System.out.println("outbound i = " + i2);
                        }
                    }
                }
                try {
                    if (this.inboundCorrelations == null || refresh) {
                        Query inBoundCorrelationsQuery = LogQueryBuilder.createInboundCorrelationQuery((List)this.agentsList, (ILogFilterCriteria)this.getFilterCriteria());
                        ((TimeBasedCorrelationQuery)inBoundCorrelationsQuery).setCorrelationContainerURI(correlationContainerURI.toString());
                        this.inboundCorrelations = LogQueryBuilder.executeQuery((Query)inBoundCorrelationsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                    }
                }
                catch (Exception e) {
                    if (!this.debug) break block27;
                    e.printStackTrace();
                }
            }
            if (this.inboundCorrelations == null) {
                return;
            }
            resultEntry = (ResultEntry)this.inboundCorrelations.getResultEntries().get(0);
            valuesList = resultEntry.getObjects();
            resultEntry = (ResultEntry)this.inboundCorrelations.getResultEntries().get(1);
            keysList = resultEntry.getObjects();
            source = null;
            target = null;
            index = -1;
            s = currentPageList.size();
            for (i = 0; i < s && (index = valuesList.indexOf(target = (CBECommonBaseEvent)currentPageList.get(i))) < 0; ++i) {
            }
            if (this.debug) {
                System.out.println("Index inbound = " + index);
                System.out.println("keysList size = " + keysList.size());
                System.out.println("valuesList size = " + valuesList.size());
            }
            i = 0;
            try {
                if (index <= -1) break block28;
                s = valuesList.size();
                for (i = index; i < s; ++i) {
                    source = (CBECommonBaseEvent)keysList.get(i);
                    target = (CBECommonBaseEvent)valuesList.get(i);
                    if (this.currentPageEvents.get(target) != null) {
                        if (this.currentPageEvents.get(source) != null) continue;
                        this.createSourceOutOfPageMessage(source, target);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!this.debug) break block28;
                e.printStackTrace();
                System.out.println("inbound i = " + i);
            }
        }
    }

    protected void generateGraphNodes() {
        EObject key = null;
        CBECommonBaseEvent element = null;
        TraceLifeline lifeline = null;
        LogGraphNode node = null;
        LogGraphNode previousNode = null;
        int k = this.getMaxCurrentPageRangeIndex();
        int startPageIndex = this.currentPageIndex * this.PAGE_SIZE;
        int endPageIndex = this.currentPageIndex * this.PAGE_SIZE + k;
        for (int i = startPageIndex; i < endPageIndex; ++i) {
            key = (EObject)this.eventsList.get(i);
            if (!(key instanceof CBECommonBaseEvent)) continue;
            element = (CBECommonBaseEvent)key;
            lifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(element)));
            if (this.graphNodes.get(element) != null) continue;
            node = this.createLogGraphNode(lifeline, element, previousNode);
            this.cacheLogGraphNode(node, element);
            previousNode = node;
        }
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent element) {
        return element.getAgent().getAgentProxy();
    }

    protected void cacheLogGraphNode(LogGraphNode node, CBECommonBaseEvent element) {
        if (this.correlationContainerProxy == null) {
            return;
        }
        this.graphNodes.put(element, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateGraphConnectionsXMI() {
        EMap correlations;
        if (this.correlationContainerProxy == null) {
            return;
        }
        CBECommonBaseEvent source = null;
        List targetList = null;
        CorrelationEntryImpl entry = null;
        Object key = null;
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap eMap = correlations = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        synchronized (eMap) {
            Iterator iter = correlations.iterator();
            while (iter.hasNext()) {
                entry = (CorrelationEntryImpl)iter.next();
                key = entry.getKey();
                if (!(key instanceof CBECommonBaseEvent) || !this.isFilterApplied((EObject)(source = (CBECommonBaseEvent)key)) || (targetList = (List)entry.getValue()) == null) continue;
                int s = targetList.size();
                for (int i = 0; i < s; ++i) {
                    CBECommonBaseEvent target = (CBECommonBaseEvent)targetList.get(i);
                    if (!this.isFilterApplied((EObject)target)) continue;
                    if (this.currentPageEvents.get(source) == null) {
                        if (this.currentPageEvents.get(target) == null) continue;
                        this.createSourceOutOfPageMessage(source, target);
                        continue;
                    }
                    if (this.currentPageEvents.get(target) != null) {
                        if (this.inExpandedList(source) && source != this.thisSelection && target != this.thisSelection) {
                            this.createDummyMessage(source);
                            continue;
                        }
                        this.createAsyncMessage(source, target);
                        continue;
                    }
                    if (!this.inExpandedList(source) || source == this.thisSelection) {
                        this.createTargetOutOfPageMessage(source, target);
                        continue;
                    }
                    this.createDummyMessage(source);
                }
            }
        }
    }

    private LogAsyncReturnMessage createDummyMessage(CBECommonBaseEvent source) {
        LogGraphNode sourceNode = (LogGraphNode)((Object)this.graphNodes.get(source));
        LogAsyncReturnMessage message = this.getDummyMessage(source);
        if (message != null) {
            return message;
        }
        message = this.isInputXMI ? new LogAsyncReturnMessage(0) : new LogAsyncReturnMessage(1);
        message.setStartLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source))));
        message.setSource(source);
        message.setStartOccurrence(((LogGraphNode)((Object)this.graphNodes.get(source))).getStartOccurrence());
        this.frame.addMessage((BaseMessage)message);
        this.dummyMessages.put(source, message);
        return message;
    }

    private SourceOutOfPageMessage createSourceOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        SourceOutOfPageMessage message = this.getSourceMessage(target);
        ArrayList<CBECommonBaseEvent> sources = null;
        if (message == null) {
            sources = new ArrayList<CBECommonBaseEvent>();
            sources.add(source);
            message = new SourceOutOfPageMessage();
            message.setEndLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(target))));
            LogGraphNode targetNode = (LogGraphNode)((Object)this.graphNodes.get(target));
            message.setEndOccurrence(targetNode.getEndOccurrence());
            message.setSource(sources);
            this.sourceOutOfPageMessages.put(target, message);
        } else {
            sources = message.getSource();
            sources.add(source);
        }
        this.frame.addMessage((BaseMessage)message);
        return message;
    }

    protected LogInteractionsFrame createPage(boolean refresh) {
        if (this.currentPageIndex > this.pageCache.length - 1 || refresh) {
            this.frame = new LogInteractionsFrame();
        } else {
            LogInteractionsFrame currentFrame = (LogInteractionsFrame)((Object)this.pageCache[this.currentPageIndex]);
            if (currentFrame != null) {
                this.frame = currentFrame;
                this.cacheGraphNodes();
                this.cacheCurrentPageEvents();
                return this.frame;
            }
            this.frame = new LogInteractionsFrame();
        }
        this.frame.setLifelineCategories(traceCategories);
        this.frame.forceEventOccurrenceSpacing(24);
        this.clearTemporaryCaches();
        this.generateLifelines();
        this.cacheCurrentPageEvents();
        this.frame.setName(this.getFrameTitle());
        this.generateDiagram(false);
        this.pageCache[this.currentPageIndex] = this.frame;
        return this.frame;
    }

    private void cacheCurrentPageEvents() {
        this.currentPageEvents.clear();
        int k = this.getMaxCurrentPageRangeIndex();
        int startPageIndex = this.currentPageIndex * this.PAGE_SIZE;
        int endPageIndex = this.currentPageIndex * this.PAGE_SIZE + k;
        if (endPageIndex > this.eventsList.size()) {
            this.currentPageIndex = 0;
            k = this.getMaxCurrentPageRangeIndex();
            startPageIndex = 0;
            endPageIndex = k;
        }
        for (int i = startPageIndex; i < endPageIndex; ++i) {
            EObject element = (EObject)this.eventsList.get(i);
            if (!(element instanceof CBECommonBaseEvent)) continue;
            this.currentPageEvents.put(element, "");
        }
    }

    protected String getFrameTitle() {
        return SDLogcPlugin.getString("STR_MENU_LOR") + ":      " + this.getFrameName();
    }

    protected void generateLifelines() {
        Iterator iter = this.getLifelineArtifactsList().iterator();
        while (iter.hasNext()) {
            TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
            TraceLifeline lifeLine = new TraceLifeline();
            lifeLine.setName(trcAgentProxy.getName());
            lifeLine.setCategory(0);
            this.lifelinesMap.put(trcAgentProxy, lifeLine);
            this.frame.addLifeLine(lifeLine);
        }
    }

    protected List getLifelineArtifactsList() {
        return this.agentsList;
    }

    private int getMaxCurrentPageRangeIndex() {
        int r = this.totalSize % this.PAGE_SIZE;
        if (this.totalSize == 0) {
            return 0;
        }
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            return this.PAGE_SIZE;
        }
        if (r == 0) {
            return this.PAGE_SIZE;
        }
        return r;
    }

    protected LogGraphNode createLogGraphNode(TraceLifeline lifeline, CBECommonBaseEvent object, LogGraphNode previousNode) {
        LogGraphNode node = null;
        if (previousNode != null) {
            if (((LogRecordComparator)this.getComparator()).compareByTime(object, previousNode.getElement()) == 1) {
                node = new LogGraphNode((EObject)object);
                lifeline.setCurrentEventOccurrence(this.frame.getMaxEventOccurrence());
                node.setStartOccurrence(lifeline.getNewEventOccurrence());
                node.setEndOccurrence(lifeline.getNewEventOccurrence());
                node.setName(object.getMsg());
                lifeline.addExecution((BasicExecutionOccurrence)node);
                node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
            } else if ((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey((CBECommonBaseEvent)previousNode.getElement()))) == lifeline) {
                if (!this.inExpandedList(object)) {
                    previousNode.addElement((EObject)object);
                    node = previousNode;
                    node.setName(TString.change((String)SDLogcPlugin.getString("STR_EXPAND_NODE"), (String)"%1", (String)("" + node.getElements().size())));
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                } else {
                    node = new LogGraphNode((EObject)object);
                    node.setStartOccurrence(previousNode.getEndOccurrence());
                    lifeline.setCurrentEventOccurrence(previousNode.getEndOccurrence());
                    node.setEndOccurrence(lifeline.getNewEventOccurrence());
                    node.setExpanded(true);
                    node.setName(object.getMsg());
                    lifeline.addExecution((BasicExecutionOccurrence)node);
                    LogGraphNode parentNode = this.getParentNode(object);
                    parentNode.addElement((EObject)object);
                    parentNode.setExpanded(true);
                    parentNode.setBackgroundColor();
                    node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                }
            } else {
                List executions = lifeline.getExecutions();
                if (executions.size() > 0) {
                    LogGraphNode lastGraphNode = (LogGraphNode)((Object)executions.get(executions.size() - 1));
                    if (lastGraphNode != null) {
                        if (((LogRecordComparator)this.getComparator()).compareByTime(object, lastGraphNode.getElement()) == 1) {
                            node = new LogGraphNode((EObject)object);
                            node.setStartOccurrence(previousNode.getStartOccurrence());
                            node.setEndOccurrence(previousNode.getEndOccurrence());
                            node.setName(object.getMsg());
                            lifeline.addExecution((BasicExecutionOccurrence)node);
                            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        } else if (!this.inExpandedList(object)) {
                            lastGraphNode.addElement((EObject)object);
                            node = lastGraphNode;
                            node.setName(TString.change((String)SDLogcPlugin.getString("STR_EXPAND_NODE"), (String)"%1", (String)("" + node.getElements().size())));
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        } else {
                            node = new LogGraphNode((EObject)object);
                            node.setStartOccurrence(lastGraphNode.getEndOccurrence());
                            lifeline.setCurrentEventOccurrence(lastGraphNode.getEndOccurrence());
                            node.setEndOccurrence(lifeline.getNewEventOccurrence());
                            node.setName(object.getMsg());
                            node.setExpanded(true);
                            lifeline.addExecution((BasicExecutionOccurrence)node);
                            LogGraphNode parentNode = this.getParentNode(object);
                            parentNode.addElement((EObject)object);
                            parentNode.setExpanded(true);
                            parentNode.setBackgroundColor();
                            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        }
                    }
                } else {
                    node = new LogGraphNode((EObject)object);
                    node.setStartOccurrence(previousNode.getStartOccurrence());
                    node.setEndOccurrence(previousNode.getEndOccurrence());
                    node.setName(object.getMsg());
                    lifeline.addExecution((BasicExecutionOccurrence)node);
                    node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                }
            }
        } else {
            node = new LogGraphNode((EObject)object);
            node.setStartOccurrence(lifeline.getNewEventOccurrence());
            node.setEndOccurrence(lifeline.getNewEventOccurrence());
            node.setName(object.getMsg());
            lifeline.addExecution((BasicExecutionOccurrence)node);
            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
        }
        node.setBackgroundColor();
        return node;
    }

    private AsyncMessage createAsyncMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        TraceLifeline sourceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source)));
        TraceLifeline targetLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(target)));
        LogGraphNode sourceNode = (LogGraphNode)((Object)this.graphNodes.get(source));
        LogGraphNode targetNode = (LogGraphNode)((Object)this.graphNodes.get(target));
        LogAsyncMessage message = null;
        message = this.isInputXMI ? new LogAsyncMessage(0) : new LogAsyncMessage(1);
        message.setStartLifeline(sourceLifeline);
        message.setEndLifeline(targetLifeline);
        message.setStartOccurrence(sourceNode.getStartOccurrence());
        message.setEndOccurrence(targetNode.getStartOccurrence());
        message.setSourceNode(sourceNode);
        message.setTargetNode(targetNode);
        this.frame.addMessage((BaseMessage)message);
        return message;
    }

    private TargetOutOfPageMessage createTargetOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        TraceLifeline sourceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source)));
        LogGraphNode sourceNode = (LogGraphNode)((Object)this.graphNodes.get(source));
        ArrayList<CBECommonBaseEvent> targets = null;
        TargetOutOfPageMessage message = this.getTargetMessage(source);
        if (message == null) {
            targets = new ArrayList<CBECommonBaseEvent>();
            targets.add(target);
            message = new TargetOutOfPageMessage();
            message.setStartLifeline(sourceLifeline);
            message.setStartOccurrence(sourceNode.getEndOccurrence());
            message.setTarget(targets);
            this.targetOutOfPageMessages.put(source, message);
            this.frame.addMessage((BaseMessage)message);
        } else {
            targets = message.getTarget();
            targets.add(target);
        }
        return message;
    }

    protected void addEvents(TRCAgentProxy trcAgentProxy) {
        this.eventsList.addAll(trcAgentProxy.getAgent().getDefaultEvents());
    }

    protected void cacheGraphNodes() {
        this.graphNodes.clear();
        TraceLifeline lifeline = null;
        for (int i = 0; i < this.frame.getLifelines().size(); ++i) {
            lifeline = (TraceLifeline)((Object)this.frame.getLifelines().get(i));
            for (int k = 0; k < lifeline.getExecutions().size(); ++k) {
                LogGraphNode graphNode = (LogGraphNode)((Object)lifeline.getExecutions().get(k));
                if (graphNode == null) continue;
                if (graphNode.hasElements()) {
                    for (int j = 0; j < graphNode.getElements().size(); ++j) {
                        this.graphNodes.put(graphNode.getElements().get(j), graphNode);
                    }
                    continue;
                }
                this.graphNodes.put(graphNode.getElement(), graphNode);
            }
        }
    }

    protected LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent artifact) {
        Object graphNode = null;
        LogGraphNode source = null;
        source = (LogGraphNode)((Object)this.graphNodes.get(artifact));
        return source;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof INavigator && !((INavigator)part).isLinkingEnabled()) {
            return;
        }
        if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
            EObject sel = HyadesUtil.getMofObject();
            if (sel != null && sel != this.inputObject) {
                this.view.setFrame((Frame)this.parseModel(sel));
                this.disableMessageActions();
                Object viewSel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
                if (viewSel != null && viewSel instanceof CBECommonBaseEvent) {
                    this.setSelection((CBECommonBaseEvent)viewSel);
                }
            } else if (sel == null) {
                this.inputObject = sel;
                this.view.setFrame(new Frame());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelection() == null || ((IStructuredSelection)e.getSelection()).size() == 0) {
            return;
        }
        Object sel = ((IStructuredSelection)e.getSelection()).getFirstElement();
        if (sel instanceof LogGraphNode && this.view.getSDWidget().getViewControl().isFocusControl()) {
            CBECommonBaseEvent lastSelection = this.currentSelection;
            this.thisSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)sel)).getElement();
            if (this.thisSelection != lastSelection && (this.inExpandedList(this.thisSelection) || this.inExpandedList(lastSelection))) {
                this.revealGraphConnections(this.thisSelection);
                return;
            }
            this.currentSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)sel)).getElement();
            LogUtil.notifyViewSelectionChanged((Object)this, (Object)this.currentSelection);
        }
    }

    public boolean isDisplayingOnlyCorrelations() {
        return this.displayOnlyCorrelations;
    }

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean isSyncMessageReturnSupported() {
        return true;
    }

    public boolean isAsyncMessageSupported() {
        return true;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean hasNextPage() {
        return this.currentPageIndex + 1 < this.nrOfPages;
    }

    public boolean hasPrevPage() {
        return this.currentPageIndex > 0;
    }

    public void nextPage() {
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            ++this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    public void prevPage() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    protected void createPartition() {
        this.totalSize = this.eventsList.size();
        this.PAGE_SIZE = (int)SDLogcPlugin.getDefault().getPreferenceStore().getLong("page_size");
        this.nrOfPages = this.totalSize % this.PAGE_SIZE > 0 ? this.totalSize / this.PAGE_SIZE + 1 : this.totalSize / this.PAGE_SIZE;
        this.pageCache = this.nrOfPages == 0 ? new Object[1] : new Object[this.nrOfPages];
    }

    public String getTitleString() {
        String title = SDLogcPlugin.getString("STR_VIEW_TITLE") + ": " + SDLogcPlugin.getString("STR_MENU_LOR");
        if (this.correlationContainerProxy != null) {
            title = title + " <" + this.correlationContainerProxy.getCorrelationEngine().getName() + "> ";
        }
        return title;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object sel;
        Object source = event.getSource();
        if (source != this && (sel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement()) instanceof CBECommonBaseEvent) {
            this.setSelection((CBECommonBaseEvent)sel);
        }
    }

    private void showCorrelationDialog() {
        LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
        logCorrelationSelectionDialog.open();
        if (logCorrelationSelectionDialog.getReturnCode() == 0) {
            this.setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
            this.correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)this.inputObject, this.correlationType.getAttribute("name"));
            this.inputObject = this.correlationContainerProxy;
            LogUtil.selectInLogNavigator((EObject)this.correlationContainerProxy);
        }
    }

    public void setSelection(CBECommonBaseEvent sel) {
        if (this.view == null) {
            return;
        }
        this.view.getSDWidget().clearSelection();
        if (this.eventsList != null) {
            int i = this.eventsList.indexOf(sel);
            int pageIndex = 0;
            if (i > -1) {
                pageIndex = i / this.PAGE_SIZE;
            }
            this.goToPage(pageIndex);
            LogGraphNode node = this.getGraphNodeFromArtifact(sel);
            CBECommonBaseEvent lastSelection = this.currentSelection;
            this.thisSelection = sel;
            if (this.thisSelection != lastSelection && (this.inExpandedList(this.thisSelection) || this.inExpandedList(lastSelection))) {
                this.revealGraphConnections(this.thisSelection);
            } else {
                this.currentSelection = sel;
                this.view.setFrameAndEnsureVisible((Frame)this.frame, (GraphNode)node);
                this.disableMessageActions();
                this.view.getSDWidget().addSelection((GraphNode)node);
            }
        }
    }

    private void goToPage(int page) {
        this.currentPageIndex = page;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.view.updateCoolBar();
    }

    public IConfigurationElement getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(IConfigurationElement element) {
        this.correlationType = element;
    }

    public Action getFilterAction() {
        String STR_FILTER_RECORD = SDLogcPlugin.getString("STR_FILTER_RECORD");
        Action advfilter = new Action(STR_FILTER_RECORD){

            public void run() {
                LogInteractions.this.filter();
            }
        };
        advfilter.setText(STR_FILTER_RECORD);
        advfilter.setDescription(STR_FILTER_RECORD);
        advfilter.setToolTipText(STR_FILTER_RECORD);
        return advfilter;
    }

    public void filter() {
        FiltersDialog dialog = new FiltersDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FILTER_SETTINGS"), null, (ILogFilterProvider)this, true);
        dialog.open();
    }

    public Action getFindAction() {
        String STR_FIND_RECORD = SDLogcPlugin.getString("STR_FIND_RECORD");
        Action searchRecord = new Action(STR_FIND_RECORD){

            public void run() {
                LogInteractions.this.find();
            }
        };
        searchRecord.setText(STR_FIND_RECORD);
        searchRecord.setDescription(STR_FIND_RECORD);
        searchRecord.setToolTipText(STR_FIND_RECORD);
        return searchRecord;
    }

    public void find() {
        this.dialog = new SearchRecordDialog(this.view.getViewSite().getShell(), SDLogcPlugin.getString("STR_ST_FIND_SETTINGS"), null, (ILogFindProvider)this);
        this.initializeRecordSearchEngine();
        this.dialog.open();
    }

    public boolean filterRecord(ILogFilterCriteria criteria) {
        this.filterTableElements = criteria.getFilters();
        Map options = criteria.getFilterOptions();
        if (options != null && options.get("correlated") != null) {
            this.displayOnlyCorrelations = options.get("correlated").equals("1");
        }
        this.generateLogInteractions(this.inputObject, false);
        return true;
    }

    public boolean findRecord(LogFindCriteria criteria) {
        Object sel = null;
        LogRecordSearch searchUtil = this.getRecordSearchEngine();
        if (this.isInputXMI) {
            searchUtil.initStartNode((Object)this.currentSelection, 0);
            sel = searchUtil.search(criteria.getFilters(), criteria.isForwardDirection() ? 1 : -1, (Object)this.currentSelection);
        } else {
            sel = searchUtil.search(this.query, criteria);
        }
        this.selectFindRecord(sel);
        return true;
    }

    public ILogFilterCriteria getFilterCriteria() {
        int s = 0;
        if (this.criteria == null) {
            this.criteria = new LogFilterCriteria();
        }
        if (this.filterTableElements != null) {
            s = this.filterTableElements.length;
            this.criteria.setFilters(this.filterTableElements);
            this.criteria.setSortColumns(new ISortElement[]{new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime().getName(), true), new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber().getName(), true)});
        } else {
            this.criteria.setFilters(new IFilterElement[0]);
            this.criteria.setSortColumns(new ISortElement[]{new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime().getName(), true), new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber().getName(), true)});
        }
        return this.criteria;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        return this.logRecordSearch;
    }

    private void initializeRecordSearchEngine() {
        Object start = this.getStartNode();
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        if (this.isInputXMI) {
            this.logRecordSearch.initialize(this.eventsList, start, 0);
        } else {
            this.logRecordSearch.initialize(this.eventsList, start, 1);
        }
    }

    private Object getStartNode() {
        return this.currentSelection;
    }

    private void selectFindRecord(Object sel) {
        if (sel == null) {
            this.dialog.updateMessage(SDLogcPlugin.getString("STR_STRING_NOT_FOUND"));
            return;
        }
        this.setSelection((CBECommonBaseEvent)sel);
    }

    public boolean storeFindOptions(LogFindCriteria criteria) {
        FilterTableElement.saveFilters((IFilterElement[])criteria.getFilters(), (String)"uml2sd_extend_find_options", (IPreferenceStore)SDLogcPlugin.getDefault().getPreferenceStore());
        SDLogcPlugin.getDefault().getPreferenceStore().setValue("uml2sd_extend_find_direction_options", criteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore store = SDLogcPlugin.getDefault().getPreferenceStore();
        return store.getString("uml2sd_extend_find_options");
    }

    public boolean loadFindDirection() {
        return SDLogcPlugin.getDefault().getPreferenceStore().getString("uml2sd_extend_find_direction_options").equals("1");
    }

    private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent event) {
        if (this.sourceOutOfPageMessages == null) {
            this.sourceOutOfPageMessages = new HashMap();
        }
        return (SourceOutOfPageMessage)((Object)this.sourceOutOfPageMessages.get(event));
    }

    private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent event) {
        if (this.targetOutOfPageMessages == null) {
            this.targetOutOfPageMessages = new HashMap();
        }
        return (TargetOutOfPageMessage)((Object)this.targetOutOfPageMessages.get(event));
    }

    private LogAsyncReturnMessage getDummyMessage(CBECommonBaseEvent event) {
        if (this.dummyMessages == null) {
            this.dummyMessages = new HashMap();
        }
        return (LogAsyncReturnMessage)((Object)this.dummyMessages.get(event));
    }

    public void handleProfileEvent(ProfileEvent event) {
        if ((event.getType() == 64 || event.getType() == 32) && event.getSource() instanceof EObject) {
            this.refresh();
        }
    }

    public int currentPage() {
        if (this.nrOfPages == 0) {
            return -1;
        }
        return this.currentPageIndex;
    }

    public String itemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public int itemsTotalCount() {
        return this.eventsList.size();
    }

    public int maxItemsByPageCount() {
        return this.PAGE_SIZE;
    }

    public String noItemsText() {
        return SDLogcPlugin.getString("STR_ITEMS");
    }

    public String oneItemText() {
        return SDLogcPlugin.getString("STR_ITEM");
    }

    public int pagesCount() {
        return this.nrOfPages;
    }

    public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
        if (0 <= pageNumber_ && pageNumber_ < this.nrOfPages) {
            this.goToPage(pageNumber_);
        }
        if (maxItemsByPage_ > this.MAX_NR_OF_RECORDS) {
            maxItemsByPage_ = this.MAX_NR_OF_RECORDS;
        }
        if (this.PAGE_SIZE != maxItemsByPage_) {
            SDLogcPlugin.getDefault().getPreferenceStore().setValue("page_size", maxItemsByPage_);
            this.PAGE_SIZE = maxItemsByPage_;
        }
    }

    public void pageNumberChanged(int pageNumber_) {
        this.goToPage(pageNumber_);
    }

    public CorrelationContainerProxy getCorrelationContainerProxy() {
        return this.correlationContainerProxy;
    }

    public String getFrameName() {
        return MessageFormat.format(SDLogcPlugin.getString("STR_PAGE_INFO"), String.valueOf(this.currentPage() + 1), String.valueOf(this.nrOfPages));
    }

    public void applyPreferences() {
        this.view.setFrame((Frame)this.parseModel(this.inputObject));
        this.disableMessageActions();
    }

    public void preserveSelection(CBECommonBaseEvent selection) {
        if (selection == null) {
            return;
        }
        this.view.getSDWidget().clearSelection();
        LogGraphNode selNode = (LogGraphNode)((Object)this.graphNodes.get(selection));
        if (selNode != null) {
            this.currentSelection = selection;
            this.view.setFrameAndEnsureVisible((Frame)this.frame, (GraphNode)selNode);
            this.disableMessageActions();
            this.view.getSDWidget().addSelection((GraphNode)selNode);
        }
    }

    public void collapseLogGraphNode(List graphNodes) {
        LogGraphNode node = null;
        for (int i = 0; i < graphNodes.size(); ++i) {
            node = (LogGraphNode)((Object)graphNodes.get(i));
            this.removeFromExpandedList(node);
        }
        node = (LogGraphNode)((Object)graphNodes.get(0));
        CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(sel);
    }

    public void expandLogGraphNode(List graphNodes) {
        LogGraphNode node = null;
        int s = graphNodes.size();
        for (int i = 0; i < s; ++i) {
            node = (LogGraphNode)((Object)graphNodes.get(i));
            this.addToExpandedList(node);
        }
        node = (LogGraphNode)((Object)graphNodes.get(0));
        CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(sel);
    }

    public LogGraphNode getParentNode(CBECommonBaseEvent event) {
        TraceLifeline eventLifeLine = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(event)));
        for (int i = 0; i < this.expandedList.size(); ++i) {
            CBECommonBaseEvent parent = (CBECommonBaseEvent)this.expandedList.get(i);
            if (this.currentPageEvents.get(parent) == null || ((LogRecordComparator)this.getComparator()).compareByTime(event, parent) != 0 || eventLifeLine != (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(parent)))) continue;
            return (LogGraphNode)((Object)this.graphNodes.get(parent));
        }
        return null;
    }

    public boolean inExpandedList(CBECommonBaseEvent event) {
        if (event == null) {
            return false;
        }
        return this.getParentNode(event) != null;
    }

    public void addToExpandedList(LogGraphNode node) {
        this.expandedList.add(node.getElement());
    }

    public void removeFromExpandedList(LogGraphNode node) {
        if (node.hasElements()) {
            this.expandedList.remove(node.getElement());
        } else {
            CBECommonBaseEvent parent = (CBECommonBaseEvent)this.getParentNode((CBECommonBaseEvent)node.getElement()).getElement();
            if (parent != null) {
                this.expandedList.remove(parent);
            }
        }
    }

    public QueryResult getCorrelations() {
        return this.outBoundCorrelations;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob() instanceof CorrelationHelper.CorrelationJob && ((CorrelationHelper.CorrelationJob)event.getJob()).getContainer() == this.inputObject) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LogInteractions.this.refresh();
                    CBECommonBaseEvent sel = (CBECommonBaseEvent)UIPlugin.getDefault().getSelectionModel(LogInteractions.this.inputObject).getFirstElement();
                    if (sel != null) {
                        LogInteractions.this.setSelection(sel);
                    }
                }
            });
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private void revealGraphConnections(CBECommonBaseEvent selection) {
        this.pageCache[this.currentPageIndex] = null;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.preserveSelection(selection);
    }

    private void disableMessageActions() {
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCalled", false);
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCaller", false);
        this.view.setEnableAction("org.eclipse.hyades.uml2sd.ui.actions.ShowStatTable", false);
    }

    private List getCurrentPageEventsList() {
        int k = this.getMaxCurrentPageRangeIndex();
        int startPageIndex = this.currentPageIndex * this.PAGE_SIZE;
        int endPageIndex = this.currentPageIndex * this.PAGE_SIZE + k;
        if (endPageIndex > this.eventsList.size()) {
            k = this.getMaxCurrentPageRangeIndex();
            startPageIndex = 0;
            endPageIndex = k;
        }
        return this.eventsList.subList(startPageIndex, endPageIndex);
    }

    static {
        LogInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName("");
        image = SDLogcPluginImages.getImage("log_obj.gif");
        traceCategories[0].setImage(image);
    }

    protected class LogRecordComparator
    implements Comparator {
        protected LogRecordComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                if (((CBECommonBaseEvent)o1).getSequenceNumber() > ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                    return 1;
                }
                if (((CBECommonBaseEvent)o1).getSequenceNumber() == ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }

        public int compareByTime(Object o1, Object o2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 0;
            }
            return -1;
        }
    }

    public class TraceLifeline
    extends Lifeline {
        public EObject model;
        public int start;
        public int end;
    }

    public class LogInteractionsFrame
    extends Frame {
        public int getMaxEventOccurrence() {
            return super.getMaxEventOccurrence();
        }

        public List getLifelines() {
            return super.getLifelines();
        }
    }
}

