/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.probekit;

/**
 * Subclass of ProbekitException, thrown when you
 * try to compile a probe set that has errors.
 * When this exception comes out of the Compiler, it means
 * the error has already been reported as a marker on the
 * resource you tried to add or compile, and no further reporting is necessary.
 * 
 * Other Probekit exceptions represent something worse, like internal
 * errors in the Probekit logic itself.
 */
public class ProbekitCompileProblemException extends ProbekitException {
	/**
	 * @param message
	 */
	public ProbekitCompileProblemException(String message) {
		super(message);
	}
}
