/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.internal.codegen;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;

/**
 * @author marcelop
 * @since 1.0.1
 */
abstract public class Generator
{
	/**
	 * Generates the code for the specified test suite, creating all the required
	 * folders, packages and adjusting the project's classpath.
	 * 
	 * <p>The location of the test suite's implementor must be equals to the source
	 * container (ie, project and source folder).  The implementor's resource must
	 * be equals to the full class name (ie, package and class name).
	 *  
	 * @param testSuite
	 * @param monitor
	 * @throws Exception
	 */
	public void generate(ITestSuite testSuite, IProgressMonitor monitor)
	throws Exception
	{
		IFile file = getFileHandle(testSuite);
		IContainer sourceContainer = getSourceContainerHandle(testSuite);
		
		if(file.exists())
			file.delete(true, true, monitor);
		else
			ResourceUtil.createContainer(sourceContainer, monitor);
		
		doGenerateFile(testSuite, sourceContainer, file, monitor);
	}
	
	protected void doGenerateFile(ITestSuite testSuite, IContainer sourceContainer, IFile file, IProgressMonitor monitor)
	throws Exception
	{
		generateFile(testSuite, file, monitor);
	}
		
	public IFile getFileHandle(ITestSuite testSuite)
	{
		IContainer sourceContainer = getSourceContainerHandle(testSuite);
		return sourceContainer.getFile(new Path(testSuite.getImplementor().getResource()));
	}
	
	protected IContainer getSourceContainerHandle(ITestSuite testSuite)
	{
		IContainer container = null;
		IPath path = new Path(testSuite.getImplementor().getLocation());
		if(path.segmentCount() == 1)
		{
			container = ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString());
		}
		else
		{
			container = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
		}
		
		return container;
	}
	
	abstract protected void generateFile(ITestSuite testSuite, IFile file, IProgressMonitor monitor)
	throws Exception;	
}
