/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;


/**
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestSuiteEditorExtension 
extends BaseEditorExtension implements IITestSuiteProvider
{
	protected static final int PAGE_OVERVIEW = 0;
	protected static final int PAGE_TEST_CASES = 1;
	protected static final int PAGE_BEHAVIOR = 2;
	
	private TestSuiteForm testSuiteForm;
	private TestCasesForm testCasesForm;
	private BehaviorForm behaviorForm;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		getTestSuiteForm().getWidgetFactory().dispose();
		getTestSuiteForm().dispose();
		getTestCasesForm().dispose();
		getBehaviorForm().dispose();
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider#getTestSuite()
	 */
	public ITestSuite getTestSuite()
	{
		return (ITestSuite)getHyadesEditorPart().getEditorObject();
	}
	
	protected void setTestSuiteForm(TestSuiteForm testSuiteForm)
	{
		this.testSuiteForm = testSuiteForm;
	}

	protected TestSuiteForm getTestSuiteForm()
	{
		return testSuiteForm;
	}

	protected void setTestCasesForm(TestCasesForm testCasesForm)
	{
		this.testCasesForm = testCasesForm;
	}

	protected TestCasesForm getTestCasesForm()
	{
		return testCasesForm;
	}

	protected void setBehaviorForm(BehaviorForm behaviorForm)
	{
		this.behaviorForm = behaviorForm;
	}

	protected BehaviorForm getBehaviorForm()
	{
		return behaviorForm;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		getTestSuiteForm().load();
		getTestSuiteForm().updateTitle();
		
		getTestCasesForm().load();
		getBehaviorForm().load();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		switch(getHyadesEditorPart().getActivePage())
		{
			case PAGE_OVERVIEW:
				return new StructuredSelection(getTestSuite());
				
			case PAGE_TEST_CASES:
				return (IStructuredSelection)getTestCasesForm().getSelection();

			case PAGE_BEHAVIOR:
				return (IStructuredSelection)getBehaviorForm().getSelection();
		}
		
		return StructuredSelection.EMPTY;
	}
		
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		switch(index)
		{
			case PAGE_OVERVIEW:
				return getTestSuiteForm().activated();
				
			case PAGE_TEST_CASES:
				return getTestCasesForm().activated();

			case PAGE_BEHAVIOR:
				return getBehaviorForm().activated();
		}
		
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object == getTestSuite())
			{
				//don't do anything
			}
			else if(object instanceof ITestCase)
			{
				getHyadesEditorPart().setActivePage(PAGE_TEST_CASES);
				getTestCasesForm().selectReveal(structuredSelection);
			}
			else if((object instanceof IImplementor) || (object instanceof IBlock) || (object instanceof IAction))
			{
				getHyadesEditorPart().setActivePage(PAGE_BEHAVIOR);
				getBehaviorForm().selectReveal(structuredSelection);
			}
		}
	}
}