/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor.action;

import org.eclipse.jface.action.Action;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Adds a loop to the block.
 * @author marcelop
 * @since 0.3.0
 */
public class AddTestCase 
extends Action implements IDisposable
{
	private IITestSuiteProvider testSuiteProvider;
	private String type;
	private String baseName;
	private boolean actionPerformed;
	
	/**
	 * Constructor for AddTestMethod
	 */
	public AddTestCase(IITestSuiteProvider testSuiteProvider, String type, String baseName)
	{
		super(TestCommonPlugin.getString("LBL_ADD"));
		this.testSuiteProvider = testSuiteProvider;
		this.type = type;
		this.baseName = baseName;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		testSuiteProvider = null;
	}
	
	public boolean actionPerformed()
	{
		return actionPerformed;
	}
	
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}

	protected ITestSuite getTestSuite()
	{
		return testSuiteProvider.getTestSuite();
	}
	
	public String getType()
	{
		return type;
	}

	public String getBaseName()
	{
		return baseName;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		adjusTestCase(TestCommonUtil.createTestCase(getTestSuite(), getType(), false, TestCommonUtil.getUniqueName(getBaseName(),  getTestSuite().getITestCases())));
		setActionPerformed(true);
	}
	
	protected void adjusTestCase(ITestCase testCase)
	{
	}
}