/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * Each variable in a datapool contains a specific type data and this
 * class represents the types that can be readily handled.  The type 
 * information is primarily advisory, variables by definition are <b>not</b>
 * strongly typed.  The type information allows the datapool editor the 
 * ability to flag data that may have been incorrectly specified and 
 * improves the ease of editing values in the datapool.  For instance 
 * specifying a {@link #TYPE_ENUMERATION} allows the editor to use an
 * editable combobox for manually changing a value rather then requiring
 * the user to get the spelling correct for each value in the available
 * value set.
 */
public interface IDatapoolSuggestedType extends
	org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType
{
	
	/**
	 * Define the type associated with a variable in the associated
	 * datapool.
	 * 
	 * @param	type	One of the predefined type formats.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 * @see	#getSuggestedType()
	 */
	public void setSuggestedType(int type);
	
	/**
	 * Defines the set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to a
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @param	enumLiterals	The set of enumerations literals associated 
	 *							with a {@link #TYPE_ENUMERATION enumeration}
	 *							type.
	 * 
	 * @see #TYPE_ENUMERATION
	 * @see #getEnumerationLiterals()
	 */
	public void setEnumerationLiterals(String[] enumLiterals);
	
	/**
	 * Defines the value class name associated with a
	 * variable.
	 * 
	 * @param	complexClassName	The complex class name associated 
	 * 								with a variable
	 * 
	 * @see #getSuggestedClassName()
	 */
	public void setSuggestedClassName(String complexClassName);
	
}
