/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.datapool;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

/**
 * @author psun
 */
public class DatapoolPlugin 
extends Plugin
{
	private static DatapoolPlugin instance;
	
	/**
	 * Constructor for DatapoolPlugin
	 * @param descriptor
	 */
	public DatapoolPlugin(IPluginDescriptor descriptor)
	{
		super(descriptor);
		instance = this;
	}

	/**
	 * Returns the instance of this class created by the eclipse framework.
	 * @return HyadesUIPlugin
	 */
	public static DatapoolPlugin getInstance()
	{
		return instance;
	}
	
	/**
	 * @see org.eclipse.core.runtime.Plugin#shutdown()
	 */
	public void shutdown()
	throws CoreException
	{
		instance = null;
		savePluginPreferences();
				
		super.shutdown();
	}

	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return instance.getDescriptor().getUniqueIdentifier();
	}

	/**
	 * Returns the resource bundle used by this plugin.
	 * 
	 * <p>IMPORTANT: Don't use this method to retrieve values from the
	 * resource bundle.  For this purpose use the static <code>getString()</code> 
	 * defined in this class.
	 * 
	 * <p>This method is provided so this resource bundle can
	 * be used as the parent of another resource bundle.
	 * 
	 * @return ResourceBundle
	 */
	public ResourceBundle getResourceBundle()
	{
		return getDescriptor().getResourceBundle();
	}
	
	/**
	 * Returns the "plugin.properties" file's value associate to a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	public static String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return instance.getDescriptor().getResourceBundle().getString(key);
	}	
}
