/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Resource extensions
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory
 * @generated
 */
public interface ExtensionsPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "extensions";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/hierarchy-extensions.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Extensions";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ExtensionsPackage eINSTANCE = org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl <em>Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQuery()
	 * @generated
	 */
	int QUERY = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__SOURCES = 1;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__DISTINCT = 2;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__COUNT = 3;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__OUTPUT_ELEMENTS = 4;

	/**
	 * The number of structural features of the the '<em>Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl <em>Simple Search Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleSearchQuery()
	 * @generated
	 */
	int SIMPLE_SEARCH_QUERY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__NAME = QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__SOURCES = QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__DISTINCT = QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__COUNT = QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS = QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__MAX_ELEMENTS = QUERY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS = QUERY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Where Expressions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS = QUERY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Simple Search Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY_FEATURE_COUNT = QUERY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl <em>Instance Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getInstanceQuery()
	 * @generated
	 */
	int INSTANCE_QUERY = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__NAME = QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__SOURCES = QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__DISTINCT = QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__COUNT = QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__OUTPUT_ELEMENTS = QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__CONDITIONS = QUERY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Instance Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY_FEATURE_COUNT = QUERY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl <em>Order By Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByElement()
	 * @generated
	 */
	int ORDER_BY_ELEMENT = 3;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__OPERATOR = 0;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__OPERAND = 1;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__SEARCH_QUERY = 2;

	/**
	 * The number of structural features of the the '<em>Order By Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl <em>Query Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQueryResult()
	 * @generated
	 */
	int QUERY_RESULT = 4;

	/**
	 * The feature id for the '<em><b>Query</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT__QUERY = 0;

	/**
	 * The feature id for the '<em><b>Result Entries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT__RESULT_ENTRIES = 1;

	/**
	 * The number of structural features of the the '<em>Query Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl <em>Simple Binary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleBinaryExpressionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleBinaryExpression()
	 * @generated
	 */
	int SIMPLE_BINARY_EXPRESSION = 5;

	/**
	 * The feature id for the '<em><b>Right Operand</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND = 0;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION__OPERATOR = 1;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY = 2;

	/**
	 * The feature id for the '<em><b>Instance Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY = 3;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION__OPERAND = 4;

	/**
	 * The number of structural features of the the '<em>Simple Binary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_BINARY_EXPRESSION_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.LeftOperandImpl <em>Left Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.LeftOperandImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getLeftOperand()
	 * @generated
	 */
	int LEFT_OPERAND = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND__NAME = 0;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND__COUNT = 1;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND__QUERY = 2;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND__FEATURE = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND__TYPE = 4;

	/**
	 * The number of structural features of the the '<em>Left Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_OPERAND_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl <em>Result Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getResultEntry()
	 * @generated
	 */
	int RESULT_ENTRY = 7;

	/**
	 * The feature id for the '<em><b>Objects</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_ENTRY__OBJECTS = 0;

	/**
	 * The number of structural features of the the '<em>Result Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_ENTRY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl <em>Correlation Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getCorrelationQuery()
	 * @generated
	 */
	int CORRELATION_QUERY = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__NAME = SIMPLE_SEARCH_QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__SOURCES = SIMPLE_SEARCH_QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__DISTINCT = SIMPLE_SEARCH_QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__COUNT = SIMPLE_SEARCH_QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__OUTPUT_ELEMENTS = SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__MAX_ELEMENTS = SIMPLE_SEARCH_QUERY__MAX_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__ORDER_BY_EXPRESIONS = SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS;

	/**
	 * The feature id for the '<em><b>Where Expressions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__WHERE_EXPRESSIONS = SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS;

	/**
	 * The feature id for the '<em><b>Correlation Container URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__CORRELATION_CONTAINER_URI = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Delta Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__DELTA_TIME = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Correlation Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY_FEATURE_COUNT = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl <em>Time Based Correlation Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getTimeBasedCorrelationQuery()
	 * @generated
	 */
	int TIME_BASED_CORRELATION_QUERY = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__NAME = CORRELATION_QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__SOURCES = CORRELATION_QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__DISTINCT = CORRELATION_QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__COUNT = CORRELATION_QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__OUTPUT_ELEMENTS = CORRELATION_QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__MAX_ELEMENTS = CORRELATION_QUERY__MAX_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__ORDER_BY_EXPRESIONS = CORRELATION_QUERY__ORDER_BY_EXPRESIONS;

	/**
	 * The feature id for the '<em><b>Where Expressions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__WHERE_EXPRESSIONS = CORRELATION_QUERY__WHERE_EXPRESSIONS;

	/**
	 * The feature id for the '<em><b>Correlation Container URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__CORRELATION_CONTAINER_URI = CORRELATION_QUERY__CORRELATION_CONTAINER_URI;

	/**
	 * The feature id for the '<em><b>Delta Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__DELTA_TIME = CORRELATION_QUERY__DELTA_TIME;

	/**
	 * The number of structural features of the the '<em>Time Based Correlation Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY_FEATURE_COUNT = CORRELATION_QUERY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators <em>Relational Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getRelationalOperators()
	 * @generated
	 */
	int RELATIONAL_OPERATORS = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators <em>Order By Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByOperators()
	 * @generated
	 */
	int ORDER_BY_OPERATORS = 11;

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.Query <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query
	 * @generated
	 */
	EClass getQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getName()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Name();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSources <em>Sources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Sources</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getSources()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Sources();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distinct</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Distinct();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#isCount()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Count();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements <em>Output Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Output Elements</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_OutputElements();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery <em>Simple Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery
	 * @generated
	 */
	EClass getSimpleSearchQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements <em>Max Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Elements</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EAttribute getSimpleSearchQuery_MaxElements();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getOrderByExpresions <em>Order By Expresions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Order By Expresions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getOrderByExpresions()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EReference getSimpleSearchQuery_OrderByExpresions();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpressions <em>Where Expressions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Where Expressions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpressions()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EReference getSimpleSearchQuery_WhereExpressions();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery <em>Instance Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Instance Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery
	 * @generated
	 */
	EClass getInstanceQuery();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Conditions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions()
	 * @see #getInstanceQuery()
	 * @generated
	 */
	EReference getInstanceQuery_Conditions();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement <em>Order By Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Order By Element</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement
	 * @generated
	 */
	EClass getOrderByElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperator()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EAttribute getOrderByElement_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperand()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EReference getOrderByElement_Operand();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EReference getOrderByElement_SearchQuery();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult <em>Query Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Result</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult
	 * @generated
	 */
	EClass getQueryResult();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getQuery()
	 * @see #getQueryResult()
	 * @generated
	 */
	EReference getQueryResult_Query();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getResultEntries <em>Result Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Result Entries</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getResultEntries()
	 * @see #getQueryResult()
	 * @generated
	 */
	EReference getQueryResult_ResultEntries();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression <em>Simple Binary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Binary Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression
	 * @generated
	 */
	EClass getSimpleBinaryExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getRightOperand <em>Right Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Right Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getRightOperand()
	 * @see #getSimpleBinaryExpression()
	 * @generated
	 */
	EAttribute getSimpleBinaryExpression_RightOperand();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperator()
	 * @see #getSimpleBinaryExpression()
	 * @generated
	 */
	EAttribute getSimpleBinaryExpression_Operator();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getSearchQuery()
	 * @see #getSimpleBinaryExpression()
	 * @generated
	 */
	EReference getSimpleBinaryExpression_SearchQuery();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getInstanceQuery <em>Instance Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Instance Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getInstanceQuery()
	 * @see #getSimpleBinaryExpression()
	 * @generated
	 */
	EReference getSimpleBinaryExpression_InstanceQuery();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperand()
	 * @see #getSimpleBinaryExpression()
	 * @generated
	 */
	EReference getSimpleBinaryExpression_Operand();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand <em>Left Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Left Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand
	 * @generated
	 */
	EClass getLeftOperand();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getName()
	 * @see #getLeftOperand()
	 * @generated
	 */
	EAttribute getLeftOperand_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#isCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#isCount()
	 * @see #getLeftOperand()
	 * @generated
	 */
	EAttribute getLeftOperand_Count();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getQuery()
	 * @see #getLeftOperand()
	 * @generated
	 */
	EReference getLeftOperand_Query();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feature</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getFeature()
	 * @see #getLeftOperand()
	 * @generated
	 */
	EReference getLeftOperand_Feature();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LeftOperand#getType()
	 * @see #getLeftOperand()
	 * @generated
	 */
	EReference getLeftOperand_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.ResultEntry <em>Result Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Result Entry</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ResultEntry
	 * @generated
	 */
	EClass getResultEntry();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.hierarchy.extensions.ResultEntry#getObjects <em>Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Objects</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ResultEntry#getObjects()
	 * @see #getResultEntry()
	 * @generated
	 */
	EAttribute getResultEntry_Objects();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery <em>Correlation Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Correlation Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery
	 * @generated
	 */
	EClass getCorrelationQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerURI <em>Correlation Container URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Correlation Container URI</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerURI()
	 * @see #getCorrelationQuery()
	 * @generated
	 */
	EAttribute getCorrelationQuery_CorrelationContainerURI();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getDeltaTime <em>Delta Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Delta Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getDeltaTime()
	 * @see #getCorrelationQuery()
	 * @generated
	 */
	EAttribute getCorrelationQuery_DeltaTime();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery <em>Time Based Correlation Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Based Correlation Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery
	 * @generated
	 */
	EClass getTimeBasedCorrelationQuery();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators <em>Relational Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Relational Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @generated
	 */
	EEnum getRelationalOperators();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators <em>Order By Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Order By Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators
	 * @generated
	 */
	EEnum getOrderByOperators();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ExtensionsFactory getExtensionsFactory();

} //ExtensionsPackage
