/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.plugin;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;


public class HierarchyPlugin {
	protected static IWorkspaceRoot workspaceRoot;

	public static IWorkspaceRoot getWorkspaceRoot() {
	    return workspaceRoot;
	}

    //~ Static fields/initializers -----------------------------------------------------------------

    protected static Implementation plugin;
    //~ Methods ------------------------------------------------------------------------------------

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void log(String string) {
        System.err.println(string);
    }

    //~ Inner Classes ------------------------------------------------------------------------------

    public static class Implementation extends Plugin {
        public Implementation(IPluginDescriptor descriptor) {
            super(descriptor);
            plugin = this;
        }

        public void startup() throws CoreException {
            super.startup();
			workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();            
        }
    }
}
