/*******************************************************************************
 * Copyright (c) 2003 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v0.5 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.models.hierarchy.util;
import java.io.PrintStream;
public class PerfUtil {
	long startTime, stopTime;
	long startTotMem, startFreeMem, stopTotMem, stopFreeMem;
	private String msg;
	private boolean debug=false;

	public PerfUtil(String msg,boolean start) {
		setDebugFlag();
		if(!debug)
			return;
		this.msg = msg;
		if(start)
			start();
	}
	/**
	 * 
	 */
	private void setDebugFlag() {
		try {
			 String s = System.getProperties().getProperty("PerfUtil.debug"); // use -DPerfUtil.debug=true on VMARGS to enable the probes
			 if(Boolean.valueOf(s).booleanValue())
			 {
			 	debug=true;
			 }
		} catch (Exception e) {
			//ignore and let debug on default
		}
	}
	public void start() {
		if(!debug)
			return;
		startTime = System.currentTimeMillis();
		stopTime = startTime;
		//		  Runtime.getRuntime().gc();
		startTotMem = Runtime.getRuntime().totalMemory();
		startFreeMem = Runtime.getRuntime().freeMemory();
	}
	public void stop() {
		if(!debug)
			return;
		stopTime = System.currentTimeMillis();
		//	      Runtime.getRuntime().gc();
		stopTotMem = Runtime.getRuntime().totalMemory();
		stopFreeMem = Runtime.getRuntime().freeMemory();
	}
	public long getTime() {
		return stopTime - startTime;
	}
	public void printStatus() {
		printStatus(System.out);
	}
	public void printStatus(String m) {
		if(!debug)
			return;
		this.msg+=", "+m;
		printStatus(System.out);
	}
	public void printStatus(PrintStream out) {
		if(debug)
			out.println(msg + ": deltaTime=" + getTime() + " - stopTime=" + stopTime + " - usedMemoryDelta=" + getUsedMemoryDelta() +" - freeMemoryDelta=" + getFreeMemoryDelta()+ " - totalMemoryDelta=" + getTotalMemoryDelta() + " - usedMemoryAfter=" + (stopTotMem-stopFreeMem)+ " - freeMemoryAfter=" + stopFreeMem +" - totalMemoryAfter=" + stopTotMem);
	}
	/**
	 * @return
	 */
	public long getUsedMemoryDelta() {
		return (stopTotMem-stopFreeMem)-(startTotMem-startFreeMem);
	}
	/**
	 * @return
	 */
	public long getTotalMemoryDelta() {
		return stopTotMem - startTotMem;
	}
	public long getFreeMemoryDelta() {
		return stopFreeMem - startFreeMem;
	}
	/**
	 * @param string
	 */
	public void setMessage(String msg) {
		if(!debug)
			return;
		this.msg= msg;
	}
	/**
	 * @return Returns the msg.
	 */
	public String getMessage() {
		return msg;
	}
	/**
	 * @param string
	 */
	public void setMessageAndStart(String string) {
		if(!debug)
			return;
		setMessage(string);
		start();
	}
	public void stopAndPrintStatus() {
		if(!debug)
			return;
		stop();
		printStatus();
	}
	public void stopAndPrintStatus(String msg) {
		if(!debug)
			return;
		this.msg+=", "+msg;
		stop();
		printStatus();
	}
}