/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.hyades.resources.database.internal.ObjectQuery;
/**
 * This class implements the ObjectQuery interface.
 */
public class ObjectQueryImpl implements ObjectQuery {
	protected EClass eClass;
	protected Map values;
	protected boolean setReferences;
	protected Collection notLoadedClasses;
	protected URI uri;

	/**
	 * Constructor for ObjectQueryImpl.
	 */
	public ObjectQueryImpl() {
		super();
		setReferences = true;
		values = new HashMap();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#getEClass()
	 */
	public EClass getEClass() {
		return eClass;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#setEClass(EClass)
	 */
	public void setEClass(EClass eClass) {
		this.eClass = eClass;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#getAttributeValues()
	 */
	public Map getAttributeValues() {
		return values;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#isSetReferences()
	 */
	public boolean isSetReferences() {
		return setReferences;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#setReferences(boolean)
	 */
	public void setReferences(boolean setReferences) {
		this.setReferences = setReferences;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#setNotLoadedClasses(java.util.Collection)
	 */
	public void setNotLoadedClasses(Collection classes) {
		notLoadedClasses = classes;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#getNotLoadedClasses()
	 */
	public Collection getNotLoadedClasses() {
		return notLoadedClasses;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#setURI(URI)
	 */
	public void setURI(URI uri) {
		this.uri = uri;
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.ObjectQuery#getURI()
	 */
	public URI getURI() {
		return uri;
	}
} // ObjectQueryImpl
