/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class represents the implementation of an SQLStatement.
 */
public abstract class SQLStatement {
	protected DBMap dbMap;
	protected StringBuffer statement;
	protected boolean debugPreparedStatement=false;

	/**
	 * Constructor for SQLStatement.
	 */
	public SQLStatement(DatabaseType type,DBMap map) {
		super();
		this.dbType = type;
		dbMap = map;
		statement = new StringBuffer();
	}

	/**
	 * This method returns the String representation of the statement, creating
	 * it if necessary.
	 */
	abstract public String getStatement();

	public String toString() {
		return getStatement();
	}

	protected DatabaseType dbType;

	protected String addQuotes(String name) {
		if (!dbType.getAddQuotes())
			return name;
		else
			return "\"" + name + "\"";
	}

} // SQLStatement
