/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.internal.wizard;

import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.internal.wizard.RunLocationPage;
import org.eclipse.hyades.test.java.internal.junit.wizard.RunJavaWizard;
import org.eclipse.hyades.test.manual.TestManualPlugin;
import org.eclipse.hyades.test.manual.internal.codegen.ManualGenerator;
import org.eclipse.hyades.test.manual.runner.RemoteApp;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class ManualRunWizard 
extends RunJavaWizard
{ 
	protected RunLocationPage createLocationPage()
	{
		return new RunLocationPage(false);
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.RunJavaWizard#doPerformFinish()
	 */
	public boolean doPerformFinish()
	{
//		if(true)
//		{
//			_doPerformFinish();
//			return false;
//		}
			
		ITestSuite testSuite = getTestSuite();
		Resource resource = ((TPFTestSuite)testSuite).eResource();
		boolean wasModified = resource.isModified();
		
		testSuite.getImplementor().setResource(createTestScript(testSuite));
		
		if(!wasModified)
			resource.setModified(false);
		
		return super.doPerformFinish();
	}
	
	protected ITestSuite getTestSuite()
	{
		ITestSuite testSuite = null;
		if (getTest() instanceof ITestSuite)
			testSuite = (ITestSuite)getTest();
		else if(getTest() instanceof ITestCase)
			testSuite = ((ITestCase)getTest()).getOwner();
			
		return testSuite;
	}
	
	protected String createTestScript(ITestSuite testSuite)
	{
		String testScript = ManualGenerator.generateScript(testSuite);
		if(testScript == null)
			return null;
			
		testScript = StringUtil.replace(testScript, "\r", "");
		return StringUtil.replace(testScript, "\n", "");
	}
	
	//Launches the RemoteApp without the RAC
	protected boolean _doPerformFinish()
	{
		String testScript = createTestScript(getTestSuite());
		try
		{
			if(testScript != null)
			{
				RemoteApp.main(new String[]{testScript});
				return true; 
			}
		}
		catch(Exception e)
		{
			MessageDialog.openError(getShell(), TestManualPlugin.getString("W_ERROR"), e.getMessage());
		}
		
		return false;
	}
}
