/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Mar 31, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class LogAsyncReturnMessage extends AsyncMessageReturn implements IPropertySource{
	public class SourceTargetPair {
		private CBECommonBaseEvent sourceEvent;
		private CBECommonBaseEvent targetEvent;
		
		public SourceTargetPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
			setSourceEvent(source);
			setTargetEvent(target);
		}
		
		public CBECommonBaseEvent getSourceEvent() {
			return sourceEvent;
		}

		public void setSourceEvent(CBECommonBaseEvent sourceEvent) {
			this.sourceEvent = sourceEvent;
		}

		public CBECommonBaseEvent getTargetEvent() {
			return targetEvent;
		}

		public void setTargetEvent(CBECommonBaseEvent targetEvent) {
			this.targetEvent = targetEvent;
		}
	}
	
	private List correlationList = null;
	private CBECommonBaseEvent source = null;
	private int type = 0;;
	
	public LogAsyncReturnMessage(int type){
		this.type = type;
	}
	
	public void setSource(CBECommonBaseEvent source){
		this.source=source;
	}
	
	public CBECommonBaseEvent getSource(){
		return source;
	}
	
	public void addPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
		SourceTargetPair pair = new SourceTargetPair(source,target);
		correlationList.add(pair);	
	}
	
	public List getPairs(){
		return correlationList;
	}

	public void generatePairs() {
		
		//no need to generate again if list is already generated
		if (correlationList!=null) return;

		correlationList = new ArrayList();
		
		if(source==null){
			return;
		}
		getPairs().clear();

		if(type==LogUIConstants.XMI){	
			generateCorrelationListXMI();
		}else if(type==LogUIConstants.SQL){
			generateCorrelationListSQL();
		}
		
	}
	
	/**
	 * 
	 */
	private void generateCorrelationListSQL() {

		LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
		QueryResult correlations = loader.getCorrelations();
		ResultEntry resultEntry =(ResultEntry)correlations.getResultEntries().get(0);
		List keysList = resultEntry.getObjects();
		resultEntry =(ResultEntry)correlations.getResultEntries().get(1);
		List valuesList = resultEntry.getObjects();
		
		if(keysList.size()>0){			
			CBECommonBaseEvent sourceElement = null;
			CBECommonBaseEvent target = null;
			int index = keysList.indexOf(source);			
			int s = keysList.size();			
			for(int i=index;i<s;i++){
				sourceElement = (CBECommonBaseEvent)keysList.get(i);
				target = (CBECommonBaseEvent)valuesList.get(i);
				if(sourceElement!=source)
					break;
				addPair(source,target);
			}
		}
	}

	/**
	 * 
	 */
	private void generateCorrelationListXMI() {

		List targetList = null;

		CBECommonBaseEvent targetEvent = null;
 
		LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
		EMap correlations  = loader.getCorrelationContainerProxy().getCorrelationContainer().getCorrelations();		

		targetList = (List)correlations.get(source);
		if(targetList==null){
			return;
		}
		
		int s = targetList.size();

		for(int i = 0;i < s;i++){
			targetEvent = (CBECommonBaseEvent)targetList.get(i);					
			addPair(source,targetEvent);
		}
	}

	private IPropertyDescriptor[] propertyDescriptors;
	private static final String PROPERTY_LIST = "correlation.list."; 	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getEditableValue()
	 */
	public Object getEditableValue() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		generatePairs();

		if (correlationList.size()==1) {
			if (propertyDescriptors == null) {
				propertyDescriptors = new IPropertyDescriptor[1];
				PropertyDescriptor cbeListsDescriptor = 
					new PropertyDescriptor(PROPERTY_LIST, "["+CBEUtils.formatCreationTime(((SourceTargetPair)correlationList.get(0)).getSourceEvent(),LogUIPlugin.getDateTimeFormat())+"] "+((SourceTargetPair)correlationList.get(0)).getSourceEvent().getMsg());
					cbeListsDescriptor.setLabelProvider(new LabelProvider() {
						   public String getText(Object element) {
							return  "--> ["+CBEUtils.formatCreationTime(((SourceTargetPair)correlationList.get(0)).getTargetEvent(),LogUIPlugin.getDateTimeFormat())+"] "+((SourceTargetPair)correlationList.get(0)).getTargetEvent().getMsg();
						   }
					});
				cbeListsDescriptor.setCategory(TString.change(SDLogcPlugin.getString("STR_LOG_CORR"),"%1",""+correlationList.size()));
					propertyDescriptors[0]=cbeListsDescriptor;
			}
		}
		else {
			if (propertyDescriptors == null) {
				propertyDescriptors = new IPropertyDescriptor[correlationList.size()];
				for (int i=0;i<correlationList.size();i++) {
					PropertyDescriptor cbeListsDescriptor = 
						new PropertyDescriptor(PROPERTY_LIST+i, "["+CBEUtils.formatCreationTime(((SourceTargetPair)correlationList.get(i)).getSourceEvent(),LogUIPlugin.getDateTimeFormat())+"] "+((SourceTargetPair)correlationList.get(i)).getSourceEvent().getMsg());
					final int idx = i;
					cbeListsDescriptor.setLabelProvider(new LabelProvider() {
						   public String getText(Object element) {
							return  "--> ["+CBEUtils.formatCreationTime(((SourceTargetPair)correlationList.get(idx)).getTargetEvent(),LogUIPlugin.getDateTimeFormat())+"] "+((SourceTargetPair)correlationList.get(idx)).getTargetEvent().getMsg();
						   }
						});

					cbeListsDescriptor.setCategory(TString.change(SDLogcPlugin.getString("STR_LOG_CORRS"),"%1",""+correlationList.size()));
					propertyDescriptors[i]=cbeListsDescriptor;
				}
			}
		}
		return propertyDescriptors;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		   if (((String)id).indexOf(PROPERTY_LIST)==0) {
		   	return correlationList;
		   }
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
	 */
	public void resetPropertyValue(Object id) {	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {	}

}
