/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.util.List;

import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TargetOutOfPageMessage extends AsyncMessage implements IPropertySource {
		
	private List target;
		
	/**
	 * @return EObject
	 */
	public List getTarget() {
		return target;
	}

	/**
	 * @param node
	 */
	public void setTarget(List newTarget) {
		target = newTarget;
	}
	
	private IPropertyDescriptor[] propertyDescriptors;
	private static final String PROPERTY_LIST = "target.list."; 


	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getEditableValue()
	 */
	public Object getEditableValue() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		if (target==null) return null;
		
		if (target.size()==1) {
			if (propertyDescriptors == null) {
				propertyDescriptors = new IPropertyDescriptor[1];
				CBECommonBaseEvent element = (CBECommonBaseEvent) target.get(0);
				PropertyDescriptor sourceListsDescriptor = 
					new PropertyDescriptor(PROPERTY_LIST, "["+CBEUtils.formatCreationTime(element,LogUIPlugin.getDateTimeFormat())+"] "+element.getMsg());
				sourceListsDescriptor.setLabelProvider(new LabelProvider() {
					   public String getText(Object element) {
						return  TString.change(SDLogcPlugin.getString("STR_SEVERITY_A"),"%1",""+((CBECommonBaseEvent) target.get(0)).getSeverity());
					   }
					});
				sourceListsDescriptor.setCategory(TString.change(SDLogcPlugin.getString("STR_TARGET"),"%1",""+target.size()));
				propertyDescriptors[0]=sourceListsDescriptor;
			}
		}
		else {
			if (propertyDescriptors == null) {
				propertyDescriptors = new IPropertyDescriptor[target.size()];
				for (int i=0;i<target.size();i++) {
					CBECommonBaseEvent element = (CBECommonBaseEvent) target.get(i);
					PropertyDescriptor sourceListsDescriptor = 
						new PropertyDescriptor(PROPERTY_LIST+i, i+": ["+CBEUtils.formatCreationTime(element,LogUIPlugin.getDateTimeFormat())+"] "+element.getMsg());
					final int idx = i;
					sourceListsDescriptor.setLabelProvider(new LabelProvider() {
						   public String getText(Object element) {
							return  TString.change(SDLogcPlugin.getString("STR_SEVERITY_A"),"%1",""+((CBECommonBaseEvent) target.get(idx)).getSeverity());
						   }
						});
					sourceListsDescriptor.setCategory(TString.change(SDLogcPlugin.getString("STR_TARGETS"),"%1",""+target.size()));
					propertyDescriptors[i]=sourceListsDescriptor;
					}
				}
		}
		return propertyDescriptors;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		return target;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
	 */
	public void resetPropertyValue(Object id) {}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {}

}
