/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logs.correlators;

public class CorrelationException extends Exception {
    
    private Throwable exception;

    /**
     * Create a new LogParserException with no message.
     */
    public CorrelationException() {
        super();
        this.exception = null;
    }

    /**
     * Create a new LogParserException.
     *
     * @param message The error or warning message.
     */
    public CorrelationException(String message) {
        super(message);
        this.exception = null;
    }

    /**
     * Create a new LogParserException wrapping an existing exception.
     *
     * <p>The existing exception will be embedded in the new
     * one, and its message will become the default message for
     * the LogParserException.</p>
     *
     * @param e The exception to be wrapped in a LogParserException.
     */
    public CorrelationException(Throwable e) {
        super(e.getMessage());
        this.exception = e;
    }

    /**
     * Create a new LogParserException from an existing exception.
     *
     * <p>The existing exception will be embedded in the new
     * one, but the new exception will have its own message.</p>
     *
     * @param message The detail message.
     * @param e The exception to be wrapped in a LogParserException.
     */
    public CorrelationException(String message, Throwable e) {
        super(message);
        this.exception = e;
    }

    /**
     * Return a detail message for this exception.
     *
     * <p>If there is an embedded exception, and if the LogParserException
     * has no detail message of its own, this method will return
     * the detail message from the embedded exception.</p>
     *
     * @return The error or warning message.
     */
    public String getMessage() {
        String message = super.getMessage();

        if (message == null && exception != null) {
            return exception.getMessage();
        }
        else {
            return message;
        }
    }

    /**
     * Return the embedded exception, if any.
     *
     * @return The embedded exception, or null if there is none.
     */
    public Throwable getException() {
        return exception;
    }

    public void printStackTrace() {
        super.printStackTrace();
        System.err.println("Embedded Exception follows:");
        exception.printStackTrace();
    }

    public void printStackTrace(java.io.PrintStream s) {
        super.printStackTrace(s);
        s.println("Embedded Exception follows:");
        exception.printStackTrace(s);
    }

    public void printStackTrace(java.io.PrintWriter s) {
        super.printStackTrace(s);
        s.println("Embedded Exception follows:");
        exception.printStackTrace(s);
    }

}
