/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.base;

import org.eclipse.swt.widgets.Control;

/**
 * This interface represents the behavior a hyperlink listener should have.
 * @author marcelop, bcormier
 * @since 3.0.0
 */
public interface IHyperlinkListener {
	
	/**
	 * The control which represents a hyperlink is activated
	 * @param linkLabel the control
	 */
	public void linkActivated(Control linkLabel);
	
	/**
	 * The control which represents a hyperlink is entered
	 * @param linkLabel the control
	 */
	public void linkEntered(Control linkLabel);
	
	/**
	 * The control which represents a hyperlink is exited
	 * @param linkLabel the control
	 */
	public void linkExited(Control linkLabel);
}
