/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class AddTestCaseAction 
extends AddTestSuiteChildAction
{
	private static Map testCaseTypesByTestSuiteType;
	
	/**
	 * Constructor for AddTestCaseAction
	 */
	public AddTestCaseAction()
	{
		super(TestUIPlugin.getString("BTN_ADD")); //$NON-NLS-1$
		
		setToolTipText(TestUIPlugin.getString("ACT_TST_CASE_ADD_TIP")); //$NON-NLS-1$
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_TEST_CASE));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.ADD_TCS_ACT);								
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		
		TPFTestSuite testSuite = getTestSuite(structuredSelection);
		if(testSuite == null)
			return false;
			
		String testSuiteType = testSuite.getType();
		if(testSuiteType == null)
			return false;
			
		Set testCaseTypes = null;
		if(testCaseTypesByTestSuiteType == null)
			testCaseTypesByTestSuiteType = new HashMap();
		else
			testCaseTypes = (Set)testCaseTypesByTestSuiteType.get(testSuiteType);
			
		if(testCaseTypes == null)
		{
			testCaseTypes = new HashSet();
			testCaseTypesByTestSuiteType.put(testSuiteType, testCaseTypes);
			
			IAssociationMapping testSuiteTypeValidatorMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_VALIDATORS);
			IAssociationDescriptor[] typeValidatorDescriptors = testSuiteTypeValidatorMapping.getAssociationDescriptors(testSuiteType);
			if(typeValidatorDescriptors.length == 0)
				return false;
				
			IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(TestUIPlugin.EP_TEST_CASE_WIZARD);
			String[] mappingTypes = testCaseWizardMapping.getTypes();
			
			for (int i = 0, maxi = mappingTypes.length; i < maxi; i++)
			{
				for (int j = 0, maxj = typeValidatorDescriptors.length; j < maxj; j++)
				{
					ITypeValidator typeValidator = (ITypeValidator)typeValidatorDescriptors[j].createImplementationClassInstance();
					if(typeValidator.isValidType(mappingTypes[i]))
					{
						testCaseTypes.add(mappingTypes[i]);
						break;
					}
				}
			}
		}
			
		return !testCaseTypes.isEmpty();
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		TPFTestSuite testSuite = getTestSuite(getStructuredSelection());
		Set testCaseTypes = (Set)testCaseTypesByTestSuiteType.get(testSuite.getType());
		
		List wizardElements = new ArrayList(testCaseTypes.size());
		IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(TestUIPlugin.EP_TEST_CASE_WIZARD);
        for (Iterator i = testCaseTypes.iterator(); i.hasNext();) {
            String testCaseType = (String) i.next();
            IAssociationDescriptor[] wizardDescriptors = testCaseWizardMapping.getAssociationDescriptors(testCaseType);
            for (int j = 0, maxj = wizardDescriptors.length; j < maxj; j++) {
                Object wizard = wizardDescriptors[j].createImplementationClassInstance();
                if (wizard instanceof ITestCaseWizard) {
                    WizardElement wizardElement = new WizardElement((ITestCaseWizard) wizard);
                    wizardElement.setId(wizardDescriptors[j].getId());
                    wizardElement.setLabel(wizardDescriptors[j].getName());
                    wizardElement.setDescription(wizardDescriptors[j].getDescription());
                    wizardElement.setImageDescriptor(wizardDescriptors[j].getImageDescriptor());

                    wizardElements.add(wizardElement);
                }
            }
        }

		SelectionWizard selectionWizard = new SelectionWizard((IWizardElement[])wizardElements.toArray(new IWizardElement[wizardElements.size()]), TestUIPlugin.getString("WIZ_SEL_TST_CASE")); //$NON-NLS-1$
		selectionWizard.setWindowTitle(TestUIPlugin.getString("WIZ_TST_CASE_TTL")); //$NON-NLS-1$
				
		openWizard(testSuite, selectionWizard, "TestCaseSelectionWizard"); //$NON-NLS-1$	
	}
}
