/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

import org.eclipse.emf.common.util.EList;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class VerdictEventDetailPage 
extends DetailSection.DetailPage implements IHyperlinkListener
{
	private StyledText verdictText;
	private StyledText reasonText;
	private SelectableFormLabel firstCausedByErrorLink;

	private TPFVerdictEvent verdictEvent;
	private EventForm		m_mainForm	= null;
	
	public VerdictEventDetailPage(EventForm form)
	{
		m_mainForm	= form;
	}
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		verdictEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_VERD")); //$NON-NLS-1$
		verdictText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		verdictText.setLayoutData(GridDataUtil.createHorizontalFill());
		verdictText.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_REASON")); //$NON-NLS-1$
		reasonText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		reasonText.setLayoutData(GridDataUtil.createHorizontalFill());
		reasonText.setEditable(false);
		
		firstCausedByErrorLink = widgetFactory.createSelectableLabel(composite, ""); //$NON-NLS-1$
		firstCausedByErrorLink.setText(TestUIPlugin.getString("W_FIRSTCAUSELINK")); //$NON-NLS-1$
		firstCausedByErrorLink.setToolTipText(TestUIPlugin.getString("TIP_CAUSE_LINK")); //$NON-NLS-1$
		widgetFactory.turnIntoHyperlink(firstCausedByErrorLink, this);
		firstCausedByErrorLink.setVisible( false );

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		verdictEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFVerdictEvent)
		{
			verdictEvent = (TPFVerdictEvent)object;
			if(verdictEvent != null)
			{		
				objectIsSet = true;
				
				if(verdictEvent.getVerdict() != null)
					verdictText.setText(verdictEvent.getVerdict().getLabel());
				else
					verdictText.setText(""); //$NON-NLS-1$

				if(verdictEvent.getReason() != null)
					reasonText.setText(verdictEvent.getReason().getLabel());
				else
					reasonText.setText(""); //$NON-NLS-1$
				//added following code to support cause aggregation :BGB(12/02/03)
				if ( ( verdictEvent.getCausedBy() != null ) &&
				     ( verdictEvent.getCausedBy().isEmpty() == false ) )
				{
					if ( firstCausedByErrorLink != null )
					{
						firstCausedByErrorLink.setVisible( true );
						firstCausedByErrorLink.setData( verdictEvent.getCausedBy() );
					}
				}
				else
				{
					if ( firstCausedByErrorLink != null )
						firstCausedByErrorLink.setVisible( false );
				}
			}						
		}
		
		if(!objectIsSet)
		{
			verdictText.setText(""); //$NON-NLS-1$
			reasonText.setText(""); //$NON-NLS-1$
			verdictText.setEditable(false);
			reasonText.setEditable(false);
			if ( firstCausedByErrorLink != null )
				firstCausedByErrorLink.setVisible( false );
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return verdictEvent;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		Object 	data 			= linkLabel.getData(),
				verdictObj		= null;
		EList	verdictCauses	= null;	
		
		if ( data instanceof EList )
		{
			verdictCauses	= (EList)data;
			verdictObj		= verdictCauses.get( 0 );
			if ( m_mainForm != null )
			{
				m_mainForm.revealSelect( verdictObj );
			}
		}
		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
	}
}
