/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionResultsLocationFilter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author jcanches
 */
public class ExecutionHistoryLocationProvider extends LabelProvider implements ITreeContentProvider {
	
	private IExecutionResultsLocationFilter filter;

	/**
	 * @param filter An optional filter. May be null.
	 */
	public ExecutionHistoryLocationProvider(IExecutionResultsLocationFilter filter) {
		this.filter = filter;
	}
	
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IContainer) {
			try {
				IContainer container = (IContainer)parentElement;
				IResource[] members = container.members();
				List children = new ArrayList(members.length);
				for (int i = 0; i < members.length; i++) {
					if (members[i] instanceof IContainer) {
						IContainer member = (IContainer)members[i];
						if (filter == null || !filter.isFiltered(member)) {
							children.add(member);
						}
					}
				}
				return children.toArray();
			} catch (CoreException e) {
				TestUIPlugin.logError(e);
				return new Object[0];
			}
		} else {
			return new Object[0];
		}
	}
	
	public Object getParent(Object element) {
		if (element instanceof IResource) {
			return ((IResource)element).getParent();
		}
		return null;
	}
	
	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}
	
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// NOP
	}
	
	public Image getImage(Object element) {
		if (element instanceof IContainer) {
			ImageDescriptor descriptor;
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {
				descriptor = workbenchAdapter.getImageDescriptor(element);
				if (descriptor != null)
					return descriptor.createImage();
			}
		}
		return null;
	}
	
	public String getText(Object element) {
		if (element instanceof IContainer) {
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {
				return workbenchAdapter.getLabel(element);
			}
		}
		return null;
	}
	
	private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter) Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
		if (workbenchAdapter == this)
			return null;
		return workbenchAdapter;
	}
	
}
