/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author jcanches
 */
public class TestComponentProvider extends LabelProvider implements ITreeContentProvider {
	
	private String mode;
	private String launchConfigurationType;
	
	public TestComponentProvider(String mode, String launchConfigurationType) {
		this.mode = mode;
		this.launchConfigurationType = launchConfigurationType;
	}
	
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IContainer) {
			try {
				IContainer container = (IContainer)parentElement;
				IResource[] members = container.members();
				List children = new ArrayList(members.length);
				for (int i = 0; i < members.length; i++) {
					if (members[i] instanceof IContainer) {
						children.add(members[i]);
					} else if (members[i] instanceof IFile) {
						IFile file = (IFile)members[i];
						if (ICommonConstants.TEST_COMPONENT_EXTENSION.equals(file.getFileExtension())) {
							// Attempt to find a TPFTestComponent instance in the resource
							EObject[] objs = EMFUtil.getEObjects(null, file);
							TPFTestComponent testComponent = null;
							for (int j = 0; j < objs.length; j++) {
								if (objs[j] != null && objs[j] instanceof TPFTestComponent) {
									testComponent = (TPFTestComponent)objs[j];
									break;
								}
							}
							if (testComponent != null) {
								if (isLaunchable(testComponent)) {
									children.add(testComponent);
								}
							}
						}
					}
				}
				return children.toArray();
			} catch (CoreException e) {
				TestUIPlugin.logError(e);
				return new Object[0];
			}
		} else if (parentElement instanceof TPFTestComponent) {
			return new Object[0];
		} else {
			return new Object[0];
		}
	}
	
	public Object getParent(Object element) {
		if (element instanceof IResource) {
			return ((IResource)element).getParent();
		} else if (element instanceof TPFTestComponent) {
			IFile file = EMFUtil.getWorkspaceFile((TPFTestComponent)element);
			return file;
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}
	
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// NOP
	}
	
	public Image getImage(Object element) {
		if (element instanceof IContainer) {
			ImageDescriptor descriptor;
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {
				descriptor = workbenchAdapter.getImageDescriptor(element);
				if (descriptor != null)
					return descriptor.createImage();
			}
		} else if (element instanceof TPFTestComponent) {
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_COMPONENT);
		}
		return null;
	}
	
	public String getText(Object element) {
		if (element instanceof IContainer) {
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {
				return workbenchAdapter.getLabel(element);
			}
		} else if (element instanceof TPFTestComponent) {
			return ((TPFTestComponent)element).getName();
		}
		return null;
	}
	
	private boolean isLaunchable(TPFTestComponent testComponent) {
		return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement(testComponent, mode, launchConfigurationType);
	}
	
	private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter) Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
		if (workbenchAdapter == this)
			return null;
		return workbenchAdapter;
	}
	
}
