/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.action.model.FeatureChildrenSelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles the move up action of elements that are {@link org.eclipse.emf.ecore.EStructuralFeature}
 * of an {@link org.eclipse.emf.ecore.EObject}.
 * 
 * @author bjiang
 * @since  3.0
 * @deprecated use {@link org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction} instead.
 */
public class MoveFeatureChildrenUpAction extends FeatureChildrenSelectionAction
{
	/**
	 * 
	 */
	public MoveFeatureChildrenUpAction(EObject parent, EStructuralFeature feature)
	{
		super(TestUIPlugin.getString("LBL_UP"), parent, feature); //$NON-NLS-1$

		setToolTipText(TestUIPlugin.getString("ACT_UP_DSC")); //$NON-NLS-1$
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_UP);
	}
	
	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(!super.updateSelection(selection))
			return false;
		
		EList allChildren = (EList)getEStructuralFeatureValue();
		
		if(allChildren.size() <= 1)
		{
			getChildren().clear();
			return false;
		}
		
		if((getChildren().size() == 1) && (allChildren.get(0) == getChildren().get(0)))
		{
			getChildren().clear();
			return false;			
		}
		
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);

		//TODO
		EList allChildren = (EList)getParent().eGet(getEStructuralFeature()); //getEStructuralFeatureValue();
		if(allChildren.size() <= 1)
			return;
		
		int top = 0;
		for(Iterator i=getChildren().iterator(); i.hasNext(); )
		{
			Object element = i.next();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;
				
			if(index > top)
				allChildren.move(index, index-1);
			else
				top++;
		}		

		setActionPerformed(true);
	}
}
