/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.hyades.execution.core.IExecutor;

/**
 * This interface extends the functionalities of IRunHandler. Classes that implement
 * this interface have to implement all methods from IRunHandler and IRunHandler2.
 * Implementing this interface adds the ability to perform custom action after the Test
 * is launched.
 * @author jcanches
 */
public interface IRunHandler2 extends IRunHandler {
	
	/**
	 * Method invoked after the Test Harness has launched the selected Launch Configuration.
	 * @param launch The ILaunch object that represents the instance of the Launch Configuration
	 * @param executor The executor returned by the Test Execution Harness
	 * @param monitor A Progress Monitor.
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	void postLaunch(ILaunch launch, IExecutor executor, IProgressMonitor monitor);
	
}
