/*******************************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved. This program and the accompanying materials 
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;

/**
 * @author jgout
 */
public class TestSuiteVolatileProxy implements IAdaptable {
	
	private IFile testSuiteContainer;
	private URI testSuiteURI;
	
	/**
	 * @param uri
	 * @param file
	 */
	public TestSuiteVolatileProxy(URI uri, IFile file) {
		testSuiteContainer = file;
		testSuiteURI = uri;
	}
	
	/**
	 * @return Returns the testSuiteContainer.
	 */
	public IFile getTestSuiteContainer() {
		return testSuiteContainer;
	}
	/**
	 * @return Returns the testSuiteURI.
	 */
	public URI getTestSuiteURI() {
		return testSuiteURI;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		//- this proxy is adaptable in IResource if it has been placed instead of a file
		if(adapter.equals(IResource.class) || adapter.equals(IFile.class)) {
			return testSuiteContainer;
		} else {
			return Platform.getAdapterManager().getAdapter(this, adapter);
		}
	}
}
