/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.util;

import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * This class provides a central place for utility functions used to handle 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment} resources.
 * 
 * @author bjiang
 * @since  3.0
 */
public class DeploymentUtil 
{
	public static CFGArtifactLocationPair associateTestAsset(CFGClass testAsset, TPFDeployment deployment)
	{
		CFGArtifactLocationPair pair = ConfigurationUtil.searchPairWithTestAsset(testAsset, deployment);
		if(pair == null)
		{
			// create objects in memory if they don't exist on disk
			CFGArtifact artifact = ConfigurationUtil.searchArtifactWithTestAsset(testAsset, deployment);
			if(artifact == null)
			{
				artifact = ConfigurationUtil.createArtifact(null, null);
				deployment.getArtifacts().add(artifact);
			}
			
			CFGLocation location = ConfigurationUtil.getDefaultLocation(deployment); 
			if(location == null)
			{
				location = LocationUtil.createLocation(null, null, null);
				deployment.getRefLocations().add(location);
			}
			
			pair = ConfigurationUtil.createArtifactLocationPair(artifact, location);
			deployment.getArtifactLocations().add(pair);
			deployment.eResource().setModified(true);
		}
		
		CFGArtifact artifact = pair.getArtifact();
		// force CLASSPATH to be calculated if it's not there
		ArtifactUtil.associateTestAsset(testAsset, artifact);
		
		return pair;
	}
}
