/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class LogUIPluginImages {

  private static URL fgIconBaseURL= null;

	static {
		String pathSuffix= "icons/full/"; //$NON-NLS-1$
		try {
			fgIconBaseURL= new URL(LogUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
		} catch (MalformedURLException e) {
		}
	}  
	
	/*
	 * Set of predefined Image Descriptors.
	 * the following String are all $NON-NLS-1$
	 */
	public static final String T_LCL		= "lcl16"; //$NON-NLS-1$
	public static final String T_TOOL	= "tool16"; //$NON-NLS-1$
	public static final String T_VIEW	= "view16"; //$NON-NLS-1$
	public static final String T_OBJ		= "obj16"; //$NON-NLS-1$
	public static final String T_OVR		= "ovr16"; //$NON-NLS-1$
	public static final String T_WIZBAN	= "wizban"; //$NON-NLS-1$
	public static final String T_ETOOL  = "ctool16"; //$NON-NLS-1$
	
	public static final String RECORD_FIELD = "record_obj.gif"; //$NON-NLS-1$
	public static final String IMG_UI_ENTRY = "forward_nav.gif"; //$NON-NLS-1$	
	public static final String IMG_LOG_VIEW = "was_log_view.gif";//"log_view.gif"; //$NON-NLS-1$
	public static final String IMG_MSG_VIEW = "message_log_view.gif";//"msg_view.gif"; //$NON-NLS-1$
	public static final String IMG_WAS_VIEW = "default_log_view.gif";//"diagnosed.gif"; //$NON-NLS-1$
	public static final String IMG_REFRESH = "refresh_nav.gif";//"refresh.gif"; //$NON-NLS-1$
	public static final String IMG_IMPORT_LOG = "importactivitylog_wiz.gif";//$NON-NLS-1$
	public static final String IMG_HIGH_SEV = "highseverity_obj.gif";//$NON-NLS-1$
	public static final String IMG_MED_SEV = "medseverity_obj.gif";//$NON-NLS-1$
	public static final String IMG_LOW_SEV = "lowseverity_obj.gif";//$NON-NLS-1$
	public static final String IMG_SORT = "sortrecords_co.gif";//$NON-NLS-1$
	public static final String IMG_FILTER = "filter_ps.gif"; //$NON-NLS-1$
	public static final String IMG_ADV_FILTER = "adv_filter_co.gif"; //$NON-NLS-1$
	public static final String IMG_ANALYZE_FOUND = "analyze_found_ovr.gif";//$NON-NLS-1$
	public static final String IMG_ANALYZE_NOT_FOUND = "analyze_notfound_ovr.gif";//$NON-NLS-1$
	public static final String IMG_DATE_TIME = "datetime_obj.gif";//$NON-NLS-1$
	public static final String IMG_SYMPTOM_DB = "symptomdb_obj.gif"; //$NON-NLS-1$
	public static final String IMG_IMPORT_WIZ_BAN = "importactivitylog_wiz.gif";//$NON-NLS-1$
	public static final String IMG_SEARCH_RECORD = "searchrecord.gif";//$NON-NLS-1$
	public static final String IMG_PAGE_UP = "pageup.gif";//$NON-NLS-1$
	public static final String IMG_PAGE_DOWN = "pagedown.gif";//$NON-NLS-1$
	public static final String IMG_GO_TO_PAGE = "gotopage.gif";//$NON-NLS-1$
	
	public static final String IMG_CORR_NAV = "correlation_obj.gif";//$NON-NLS-1$
	public static final String IMG_NEW_CORR_WIZ = "newcorrelation.gif";//$NON-NLS-1$
		    	
   public static final ImageDescriptor DESC_RECORD_FIELD = createManaged(T_OBJ,RECORD_FIELD);
   public static final ImageDescriptor DESC_IMG_UI_ENTRY = createManaged(T_OBJ,IMG_UI_ENTRY);   
   public static final ImageDescriptor DESC_IMG_HIGH_SEV = createManaged(T_OBJ,IMG_HIGH_SEV);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_MED_SEV = createManaged(T_OBJ,IMG_MED_SEV);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_LOW_SEV = createManaged(T_OBJ,IMG_LOW_SEV);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_SORT = createManaged(T_OBJ,IMG_SORT);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_FILTER = createManaged(T_OBJ,IMG_FILTER);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_ANALYZE_FOUND = createManaged(T_OVR,IMG_ANALYZE_FOUND);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_ANALYZE_NOT_FOUND = createManaged(T_OVR,IMG_ANALYZE_NOT_FOUND);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_DATE_TIME = createManaged(T_OBJ,IMG_DATE_TIME);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_SYMPTOM_DB = createManaged(T_OBJ,IMG_SYMPTOM_DB);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_IMPORT_WIZ_BAN = createManaged(T_WIZBAN,IMG_IMPORT_WIZ_BAN);//$NON-NLS-1$   
   public static final ImageDescriptor DESC_IMG_ADV_FILTER = createManaged(T_OBJ,IMG_ADV_FILTER);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_CORR_NAV = createManaged(T_OBJ,IMG_CORR_NAV);//$NON-NLS-1$
   public static final ImageDescriptor DESC_IMG_NEW_CORR_WIZ = createManaged(T_WIZBAN,IMG_NEW_CORR_WIZ);//$NON-NLS-1$

	protected static HashMap _images;
	protected static HashMap _imageDescriptors;

	public static Image getImage(String name)
	{
		return (Image)_images.get(name);
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		
		return (ImageDescriptor) _imageDescriptors.get(name);
	}

	private static ImageDescriptor createManaged(String prefix, String name) {
		try {
			ImageDescriptor result =
				ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));

			if (_images == null || _imageDescriptors == null) {
				_images = new HashMap();
				_imageDescriptors = new HashMap();
			}

			_imageDescriptors.put(name, result);
			_images.put(name, result.createImage());
			return result;

		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	public static void setImageDescriptors(
		IAction action,
		String type,
		String relPath) {
		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath));
			//$NON-NLS-1$
			if (id != null) {
				action.setDisabledImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath));//$NON-NLS-1$
			if (id != null) {
				action.setHoverImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		action.setImageDescriptor(create("e" + type, relPath)); //$NON-NLS-1$
	}

	private static URL makeIconFileURL(String prefix, String name)
		throws MalformedURLException {
		if (fgIconBaseURL == null)
			throw new MalformedURLException();

		StringBuffer buffer;
		if (prefix != null) {
			buffer = new StringBuffer(prefix);
			buffer.append('/');
			buffer.append(name);
		} else {
			buffer = new StringBuffer(name);
		}
		return new URL(fgIconBaseURL, buffer.toString());
	}
	
	private static ImageDescriptor create(String prefix, String name) {
		try {
			return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}	
	
	public static void shutdown() {
		if (_images == null)
			return;

		for (Iterator e = _images.values().iterator(); e.hasNext();) {
			Object next = e.next();
			if (next instanceof Image && !((Image) next).isDisposed()) {
				((Image) next).dispose();
			}
		}

		_images.clear();
		_images = null;
		_imageDescriptors.clear();
		_imageDescriptors = null;
	}
}