/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.SdUIConstants;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

/*
 * The page for setting java plugin preferences.
 */
public class SymptomDBPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private SymptomDBUI _options;

	public SymptomDBPreferencePage() {
		super();
		setPreferenceStore(SDbPlugin.getDefault().getPreferenceStore());
	}
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		LogUIPlugin.getPluginId()+".sypp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new SymptomDBUI();
		_options.createControl(composite);

		initializeValues();

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return SDbPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();

		_options.addDBPath(store.getDefaultString(SdUIConstants.SYMPTOM_DB_PATH_KEY));
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();

		_options.addDBPath(store.getString(SdUIConstants.SYMPTOM_DB_PATH_KEY));
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		SDbPlugin.getDefault().savePluginPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		_options.storeValues(getPreferenceStore());
	}
}