/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.preferences;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.SdUIConstants;
import org.eclipse.hyades.sdb.internal.wizard.ImportSymptomDBWizard;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class SymptomDBUI implements SelectionListener {

	class ColumnData {
		private String _name;
		private boolean _visible = false;

		public ColumnData(String name, boolean visible) {
			_name = name;
			_visible = visible;
		}

		public String name() {
			return _name;
		}
		public void name(String name) {
			_name = name;
		}

		public boolean visible() {
			return _visible;
		}

		public void visible(boolean visible) {
			_visible = visible;
		}
	}

	private Composite result;
	private Table _list;
	private Button _moveUp;
	private Button _moveDown;
	private Button _selAll;
	private Button _unselAll;
	private Button _restoreDefaults;
	private ArrayList _data = new ArrayList();
	private Item _oldSelection;
	private Button _add;
	private static final int _restoreDefaultsButtonId =
		IDialogConstants.CLIENT_ID + 1;
	private static final int SIZING_WIZARD_WIDTH = 500;

	public SymptomDBUI() {
		super();
	}

	/**
	 */
	public Composite createControl(Composite parent) {
		result = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 3;
		//layout.verticalSpacing = 15; Linux fix
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 320; // Linux
		data.widthHint = 400;
		result.setLayoutData(data);

		Label label = new Label(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		data.heightHint = 10;
		label.setLayoutData(data);

		Label description = new Label(result, SWT.NONE);
		description.setText(LogUIPlugin.getResourceString("STR_SYMPTOM_DB_DLG_TEXT"));

		Composite dataComp = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		dataComp.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 250;
		data.horizontalSpan = 3;
		dataComp.setLayoutData(data);

		_list = new Table(dataComp, SWT.BORDER | SWT.CHECK | SWT.H_SCROLL);
		data = GridUtil.createFill();
		_list.setLayoutData(data);

		Composite buttonWidget = new Composite(dataComp, SWT.NONE);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.verticalAlignment = GridData.FILL;
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		buttonWidget.setLayout(blayout);

		_moveUp = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveUp.setLayoutData(data);
		_moveUp.setText(LogUIPlugin.getResourceString("STR_COL_DLG_UP"));

		_moveDown = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveDown.setLayoutData(data);
		_moveDown.setText(LogUIPlugin.getResourceString("STR_COL_DLG_DOWN"));

		_selAll = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_selAll.setLayoutData(data);
		_selAll.setText(LogUIPlugin.getResourceString("STR_COL_DLG_SEL_ALL"));

		_unselAll = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_unselAll.setLayoutData(data);
		_unselAll.setText(LogUIPlugin.getResourceString("STR_COL_DLG_USEL_ALL"));

		label = new Label(buttonWidget, SWT.NULL);

		_add = new Button(buttonWidget, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.CENTER;
		_add.setLayoutData(data);
		_add.setText(LogUIPlugin.getResourceString("STR_ADD_DB"));

		_list.addSelectionListener(this);
		_moveUp.addSelectionListener(this);
		_moveDown.addSelectionListener(this);
		_selAll.addSelectionListener(this);
		_unselAll.addSelectionListener(this);
		_add.addSelectionListener(this);

		_moveUp.setEnabled(false);
		_moveDown.setEnabled(false);
		_selAll.setEnabled(false);
		_unselAll.setEnabled(false);

		WorkbenchHelp.setHelp(_list, ContextIds.SYMDB_PREF_DATABASE);

		return result;
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 4:13:01 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getData() {
		return _data;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveDown(int idx) {
		TableItem item = _list.getItem(idx);
		ColumnData data = (ColumnData) item.getData();
		TableItem newitem = new TableItem(_list, SWT.CHECK, idx + 2);
		newitem.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_SYMPTOM_DB));
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);

		newitem.setGrayed(item.getGrayed());

		_list.remove(idx);

		_list.select(idx + 1);

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveUp(int idx) {
		TableItem item = _list.getItem(idx);

		ColumnData data = (ColumnData) item.getData();

		if (idx > 0) {
			TableItem previousItem = _list.getItem(idx - 1);
			ColumnData previousItemData = (ColumnData) previousItem.getData();
		}

		TableItem newitem = new TableItem(_list, SWT.CHECK, idx - 1);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());
		newitem.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_SYMPTOM_DB));

		newitem.setData(data);
		newitem.setGrayed(item.getGrayed());

		_list.remove(idx + 1);

		_list.select(idx - 1);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:05:18 PM)
	 */
	private void populateList() {

		for (int idx = 0; idx < _data.size(); idx++) {
			ColumnData data = (ColumnData) _data.get(idx);

			TableItem item = new TableItem(_list, SWT.NONE);
			item.setText(data.name());
			item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_SYMPTOM_DB));

			item.setChecked(data.visible() == true);
			item.setData(data);
		}

		if (_list.getItemCount() > 0) {
			_selAll.setEnabled(true);
			_unselAll.setEnabled(true);
			
			_list.select(0);
			if (_list.getItemCount() > 1) {
				_moveDown.setEnabled(true);
			}
		}

		int idx = _list.getSelectionIndex();

	}

	/*
	 * 
	 */
	public void addDBPath(String symptomdbPath) {

		IWorkspace workbench = ResourcesPlugin.getWorkspace();	

		while (_list.getItemCount() > 0)
			_list.getItem(0).dispose();

		_data.clear();
		if (symptomdbPath == null || symptomdbPath.equals(""))
			return;

		int idx = symptomdbPath.indexOf(";");
		while (idx != -1) {
			String data = symptomdbPath.substring(0, idx);
			int i = data.indexOf(",");

			if (i != -1) {
				
				String filePath = data.substring(0, i);
				
				IPath path = new Path(filePath);
				IResource res = workbench.getRoot().findMember(path);	

				if(res != null && res.exists())
				{
					addColumn(filePath, data.substring(i + 1).equals("1"));
				}
			}

			symptomdbPath = symptomdbPath.substring(idx + 1);
			idx = symptomdbPath.indexOf(";");
		}

		int i = symptomdbPath.indexOf(",");

		if (i != -1) {
			
				String filePath = symptomdbPath.substring(0, i);
				
				IPath path = new Path(filePath);
				IResource res = workbench.getRoot().findMember(path);
				ColumnData col = null;	
				if(res != null && res.exists())
				{
			
					addColumn(filePath, symptomdbPath.substring(i + 1).equals("1"));					
				}
		}

		populateList();

	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == _moveUp) {
			int idx = _list.getSelectionIndex();

			if (idx > 0)
				moveUp(idx);

		} else if (e.widget == _moveDown) {
			int idx = _list.getSelectionIndex();

			if (idx != -1 && (idx < _list.getItemCount() - 1))
				moveDown(idx);

		} else if (e.widget == _selAll) {
			for (int idx = 0; idx < _list.getItemCount(); idx++) {
				TableItem item = _list.getItem(idx);
				item.setChecked(true);
			}
			return;

		} else if (e.widget == _unselAll) {
			for (int idx = 0; idx < _list.getItemCount(); idx++) {
				TableItem item = _list.getItem(idx);
				item.setChecked(false);
			}
			return;

		} else if (e.widget == _add) {
			//showSymptomsDialog();
			launchImportWizard();
			
		}

		int idx = _list.getSelectionIndex();

		ColumnData data = null;
		ColumnData previousData = null;
		if (idx > 0) {
			previousData = (ColumnData) _list.getItem(idx - 1).getData();
		}
		if (idx != -1) {
			data = (ColumnData) _list.getItem(idx).getData();
		}

		_moveUp.setEnabled(data != null && previousData != null);
		_moveDown.setEnabled(data != null && (idx < _list.getItemCount() - 1));
		_selAll.setEnabled(_list.getItemCount() > 0);
		_unselAll.setEnabled(_list.getItemCount() > 0);

	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	public void storeValues(IPreferenceStore store) {
		String data = "";
		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			TableItem item = _list.getItem(idx);

			String visible = item.getChecked() ? "1" : "0";
			data += ";" + item.getText() + "," + visible;
		}

		if (data.startsWith(";") && data.length() > 1)
			data = data.substring(1);

		store.setValue(SdUIConstants.SYMPTOM_DB_PATH_KEY, data);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/8/2001 3:43:13 PM)
	 */
	private void launchImportWizard(){
		ImportSymptomDBWizard wizard = new ImportSymptomDBWizard();
		WizardDialog dialog = new WizardDialog(result.getShell(), wizard);
		//dialog.setPageSize()
		dialog.create();
		dialog.getShell().setSize(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().y);				

		if (dialog.open() == Window.OK) {
			addDBPath(SDbPlugin.getDefault().getPreferenceStore().getString(SdUIConstants.SYMPTOM_DB_PATH_KEY));			
		}
	
	}

	private void addColumn(String filePath, boolean add){	
	
		ColumnData col = null;	
		if((col=getColumn(filePath))==null){
			col = new ColumnData(filePath, add);
			_data.add(col);
		}
		else{
			col.visible(add);
		}
	}

	private ColumnData getColumn(String col_name){
		for(int i=0;i < _data.size();i++){
			ColumnData col = (ColumnData)_data.get(i); 
			if(col.name().equals(col_name)){
				return col;
			}
		}
		return null;
	}
	/*private void showSymptomsDialog() {
		SymptomDBSelectionDialog dialog =
			new SymptomDBSelectionDialog(
				result.getShell(),
				LogUIPlugin.getResourceString("STR_RES_DLG_MSG"));

		if (dialog.open() == SymptomDBSelectionDialog.OK) {

			Object[] result = dialog.getResult();
			if (result != null && result.length == 1 && result[0] != null) {
				IPath path = (IPath) result[0];
				
				for(int idx=0; idx<_list.getItemCount(); idx++)
				{
					Object cdatao = _list.getItem(idx).getData();
					if(cdatao != null && cdatao instanceof ColumnData)
					{
						ColumnData cdata = (ColumnData)cdatao;
						if(new Path(cdata._name).equals(path))
						{
							_list.select(idx);
							return;
						}
					}
				}
				
				ColumnData data = new ColumnData(path.toString(), true);

				TableItem item = new TableItem(_list, SWT.NONE);
				item.setText(data.name());
				item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_SYMPTOM_DB));

				item.setChecked(data.visible() == true);
				item.setData(data);

			}
		}
	}*/

}