/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import java.util.Map;

import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;

/**
 * @author apnan
 */
public class LogFilterCriteria implements ILogFilterCriteria {

	private IFilterElement[] filters;
	private boolean dirty = false;
	private ISortElement[] sortElements;
	private Map options;

	public LogFilterCriteria() {
	}

	public boolean isDirty() {

		return dirty;

	}

	public IFilterElement[] getFilters() {

		return filters;

	}

	public void setFilters(IFilterElement[] list) {

		filters = list;

	}

	public ISortElement[] getSortColumns() {

		return sortElements;

	}

	public void setSortColumns(ISortElement[] columns) {

		sortElements = columns;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria#getFilterOptions()
	 */
	public Map getFilterOptions() {
		return options;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria#setFilterOptions(java.util.Map)
	 */
	public void setFilterOptions(Map options) {
		this.options = options;

	}
}