/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUIDialog;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;


/**
 * Standard workbench wizard for importing the binary WebSphere activity
 * log file (activity.log) from a local or remote file system into the
 * workspace.
 */
public class ImportLogWizard extends Wizard implements IImportWizard, IRunnableWithProgress {
    //~ Instance fields ----------------------------------------------------------------------------

    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected LogParserItem _parser;
    protected LogNavigator fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private LogParserItem currentSelectedParser;
    private boolean bAppend = false;
	private final String CANCEL = "cancel";
	private ImportLogWizardPage wizardPage;

    //~ Constructors -------------------------------------------------------------------------------

    public ImportLogWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);

        IDialogSettings workbenchSettings = plugin.getDialogSettings();

        IDialogSettings section = workbenchSettings.getSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");

        if (section == null) {
            section = workbenchSettings.addNewSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        }

        setDialogSettings(section);
    }

    //~ Methods ------------------------------------------------------------------------------------

    public LogParserItem getSelectedParser(){
		return _parser;
    }

	public List getLogFileElements(){
		return wizardPage.getLogFileElements();
	}

    public void addPages() {
        super.addPages();

        setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));

        wizardPage = new ImportLogWizardPage();
        addPage(wizardPage);

    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;

        selection = currentSelection;

        setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        if(!performPageFinish()){
        	return false;
        }
        
//		if(locPage.getSelection()){
//			TraceMergeUIDialog dialog = new TraceMergeUIDialog(getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));
//			int ret = dialog.open();
//			if(ret==Window.CANCEL){
//				return false;
//			}
//			if(ret==2){
//				bAppend = true;
//			}
//			if(ret==3){
//				bAppend = false;
//			}
//		}

        errorMessage = null;

        try {
            getContainer().run(true, true, this);
        }
        catch(InterruptedException exc)
        {
        	return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessage = e.toString();
        }

        if (errorMessage != null) {
			if(errorMessage.startsWith(CANCEL)){
				return false;
			}            
            if (reasonAction == null) {
                MessageDialog.openError(fShell, LogUIPlugin.getResourceString("LOGGING_MESSAGE"), errorMessage);
            } else {
                Status errorStatus = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, reasonAction, null);

                ErrorDialog.openError(LogUIPlugin.getActiveWorkbenchShell(), LogUIPlugin.getResourceString("LOGGING_MESSAGE"), errorMessage, errorStatus);
            }

            return false;
        }

        return true;
    }

    public void run(IProgressMonitor mon) {

    	PerfUtil p = new PerfUtil("LogImportWizard.run 1",true);

		List elements = getLogFileElements();
		
		mon.beginTask(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), elements.size() * 8);

        Node node;
		int j;
		TRCAgent _agent = null;
		for(int i=0; i<elements.size(); i++){
			j = 0;
			LogFileElement element = ((LogFileElement)elements.get(i));
			mon.subTask(element.getParser().getDescription());	
			if(element.getMergedAgent()!=null){
				
				Display.getDefault().syncExec(new Runnable(){
				  public void run(){
				  	TraceMergeUIDialog dialog = new TraceMergeUIDialog(getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));					
				  	int ret = dialog.open();
				  	if(ret==Window.CANCEL){
				  		return;
				  	}
				  	if(ret==2){
				  		bAppend = true;
				  	}
				  	if(ret==3){
				  		bAppend = false;
				  	}
				   
				  }
				});				
			}
			
			final String project = element.getProject();
			final String monitor = element.getMonitor();
			final String host = element.getHost();
			boolean localHost = true;
	        
	        try {
	            node = NodeFactory.createNode(host);
	
	            Node lnode = NodeFactory.createNode("localhost");
	
	            localHost = (node.getName().equals(lnode.getName()));
	        } catch (Exception e) {
	            errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_ERROR_");
	            reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_REASON");
	            reasonAction = HyadesUtil.change(reasonAction, "%1", host);
	
	            return;
	        }
	
	        
	            Display.getDefault().asyncExec(new Runnable(){
	            	public void run(){
						try {	
		            		IWorkbenchPage page = UIPlugin.getActivePage();
							fViewer = (LogNavigator) page.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
							fShell = fViewer.getViewSite().getShell();

							//PDProjectViewer viewer = (PDProjectViewer)fViewer.getViewer();
							StructuredViewer viewer = fViewer.getViewer();
							viewer.refresh();
							
						} catch (Exception e) {
							errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_DEST_ERROR_");
							reasonAction = null;
		
							return;
						}
						
	            		
	            	}
	            });
	            
	        	            
				            
	
	        _agent = element.getMergedAgent()!=null ? element.getMergedAgent().getAgent():null;
	        TRCProcessProxy _process;
	        final Hashtable input = getUserInput(element, true);
	
	        if (_agent == null) {
	
				IContainer container = PDCoreUtil.createContainer(new Path(project));	
				TRCMonitor trcMonitor = PDCoreUtil.createMonitor(container, monitor);
				final IContainer fContainer = container; 
				refreshView(fContainer);
				mon.worked(++j);
	
	            String portNb = UIPlugin.getDefault().getPreferenceStore().getString(HyadesConstants.LOCALHOST_PORT);
	            TRCNode trcNode = PDCoreUtil.createNode(trcMonitor, node.getName(), portNb);
				final TRCNode fNode = trcNode;
				
				final TRCMonitor fMonitor = trcMonitor;	
				refreshView(fMonitor);
	
	            _process = createProcess(container, trcNode, element);

				refreshView(fNode);
					
	            _agent = createAgent(container, _process, element);
				if(errorMessage!=null && errorMessage.startsWith(CANCEL)){
					return;
				}
				
				final TRCProcessProxy fProcess = _process;
				
				refreshView(fProcess);
		            

	        } else {
	            _process = _agent.getAgentProxy().getProcessProxy();
	
	            if (!bAppend) {
	                _agent.getDefaultEvents().clear();
	            }
	
	        }
	        mon.worked(++j);
			if (mon.isCanceled()) {
				throw new OperationCanceledException();
			}
	        
	
	        final TRCAgent trcAgent = _agent;
	        final TRCProcessProxy trcProcess = _process;
	
	        if (localHost) {
	 
				try {
					
					XMLLoader xmlLoader = new XMLLoader(trcAgent);
					xmlLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
					
					LocalLogParserLoader parserLoader = new LocalLogParserLoader(element.getParser().getParserInstance(), input);						
					parserLoader.setXMLLoader(xmlLoader);
					parserLoader.startParsing();
					xmlLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
					
					j = j+3;
					mon.worked(j);
					if (mon.isCanceled()) {
						throw new OperationCanceledException();
					}
					
					try {
						xmlLoader.cleanUp();				
					}
					catch(Exception exc)
					{
					}
								
			
				} catch (LogParserException l) {
					errorMessage = l.getMessage();
				}
				
	            //mon.done();
	        } else {
	            node = PDCoreUtil.profileConnect(host, String.valueOf(Constants.CTL_PORT_NUM_SERVER));
	
	            if (node == null) {
	                //mon.done();
	
	                break;
	            }
	
	            //mon.done();
	
	            Process process = ProcessFactory.createProcess(node, ParserConstants.REMOTE_LOG_LOADER_RAC_APPLICATION, getParserCommand(element));
	            process.addProcessListener(new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
	
	            final Agent agent = AgentFactory.createAgent(process, ParserConstants.REMOTE_LOG_LOADER_AGENT_NAME, HyadesConstants.LOG_AGENT_TYPE);
				final TRCAgentProxy aproxy = trcAgent.getAgentProxy();
	
	            agent.setAutoAttach(true);
	            agent.addAgentListener(new LogAgentListener(trcAgent, aproxy, trcProcess));
	
	            final Agent errorAgent = AgentFactory.createAgent(process, ParserConstants.REMOTE_LOG_LOADER_ERROR_AGENT_NAME, HyadesConstants.LOG_AGENT_TYPE);
	
	            errorAgent.setAutoAttach(true);
	            errorAgent.addAgentListener(new ErrorAgentListener());
	
	            try {
	                process.launch();
					j = j+3;
					mon.worked(j);
	            }
	            // The RemoteLogParserLoader application is not configured in the RAC's serviceconfig.xml file: 
	             catch (NoSuchApplicationException n) {
	                   // trying to import a new log type with an old RAC
	                   final String parserClass = element.getParser().getId().trim();
	                   if ((!parserClass.equals("com.ibm.etools.logging.parsers.WASActivityLogParser"))){
                          errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                          reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_OLD_RAC");
                          return;
	                   }
	                   Hashtable userInput = getUserInput(element, true);
	                   String was_home = ((String) (userInput.get("was_home")));
	                   final String activityPath = ((String) (userInput.get("file_path")));
	                   Process preV5Process = ProcessFactory.createProcess(node, "ActivityLogParser", ("com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(activityPath).concat("\" \"").concat(was_home).concat("\"")));
	                   preV5Process.addProcessListener(new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
	                   final Agent preV5ProcessAgent = AgentFactory.createAgent(preV5Process, "WAS Activity Log Agent", HyadesConstants.LOG_AGENT_TYPE);
	                   preV5ProcessAgent.setAutoAttach(true);
	                   preV5ProcessAgent.addAgentListener(new LogAgentListener(trcAgent, aproxy, trcProcess));
	                   final Agent preV5ErrorAgent = AgentFactory.createAgent(preV5Process, "WAS Activity Log Error Agent", HyadesConstants.LOG_AGENT_TYPE);
	                   preV5ErrorAgent.setAutoAttach(true);
	                   preV5ErrorAgent.addAgentListener(new ErrorAgentListener());
	                   try {
	                       preV5Process.launch();
	                   }
	                   catch (Exception e) {
	                       errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
	                       reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
	                       LogUIPlugin.log(e);
	                       return;
	                   }
	                 
	            } catch (Exception e) {
	                errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
	                reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
	                LogUIPlugin.log(e);
	                return;
	            }
	        }
		}
		mon.done();
		p.stopAndPrintStatus();
		final TRCAgent refreshAgent = _agent; 
		Display.getDefault().asyncExec(new Runnable(){
			public void run(){	         
			  ((TreeViewer)fViewer.getViewer()).setExpandedState(fViewer.getContentProvider().getLogFolder(), true);
			  fViewer.getViewer().setSelection(new StructuredSelection(refreshAgent.getAgentProxy()));
			  openLogView(refreshAgent);
			}
		}
		); 
    }

	private void refreshView(final Object object){

		Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					//update ui
					ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

					event.setSource(object);
					event.setType(ProfileEvent.UNSPECIFIED);
					UIPlugin.getDefault().notifyProfileEventListener(event);
				}
			});
		
		
	}
    
    protected boolean performPageFinish() {
        return wizardPage.finish();
    }

    private String getParserCommand(LogFileElement element) {
        String cmd = element.getParser().getParserClass().concat(" ");

        Hashtable input = getUserInput(element, true);
        Enumeration enum = input.keys();

        while (enum.hasMoreElements()) {
			Object key = enum.nextElement();
			String value = input.get(key).toString();
			cmd = cmd.concat("\"").concat(key.toString()).concat("=");
			if(value.endsWith("\\") || value.endsWith("/")){
				cmd = cmd.concat(value.substring(0,value.length()-1)).concat("\" ");
			}
			else{
				cmd = cmd.concat(value).concat("\" ");			
			}            
        }

        return cmd.trim();
    }

    /**
	 * @param parser
	 * @return
	 */
	private Hashtable getUserInput(LogFileElement element, boolean parserParam) {

		Hashtable table = new Hashtable();
		List fields = element.getParser().getFields();
		int i = fields.size();

		List values = element.getValues();
		for (i=0; i<fields.size();i++) {
			ParserField field = (ParserField) fields.get(i);
			table.put(field.getId(), values.get(i));			
		}
		
		if(parserParam){
		List params = element.getParser().getParserParameters();
		for (int j=0;j<params.size();j++) {
			ParserParameter param = (ParserParameter) params.get(j);
			table.put(param.getName(),param.getValue());
		}
		}
		return table;
	}

	/*
     *
     */
    private TRCAgent createAgent(IContainer container, TRCProcessProxy process, LogFileElement element) {
        TRCAgentProxy agent = null;
		String fPath = (String)getUserInput(element, false).get("file_path");
        final String name = element.getParser().getName() + (fPath!=null ? " "+fPath : "");
        
        String type = HyadesConstants.LOG_AGENT_TYPE;

        EList agents = process.getAgentProxies();
        Iterator i = agents.iterator();

        while (i.hasNext()) {
            agent = (TRCAgentProxy) i.next();

            if (agent.getName().equals(name)) {
				if(element.getMergedAgent()==null){

					Display.getDefault().syncExec(new Runnable(){
						public void run(){	            
							String msg = LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_1");
							msg = TString.change(msg, "%1", name);
							TraceMergeUIDialog dialog = new TraceMergeUIDialog(getShell(), msg);
							int ret = dialog.open();
							if(ret==Window.CANCEL){
								errorMessage = CANCEL;												
							}
							if(ret==2){
								bAppend = true;
							}
							if(ret==3){
								bAppend = false;
							}
						}
					}
					);


				}
                
                if(errorMessage == CANCEL)
                	return null;
                	
                if (bAppend) {
                    return agent.getAgent();
                } else {
                    agent.getAgent().getDefaultEvents().clear();

                    return agent.getAgent();
                }
            }
        }

		Date currentDate = new Date();
        String timestamp = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL).format(currentDate);
        String rID = timestamp;

        rID = HyadesUtil.change(rID, " ", "");
        rID = HyadesUtil.change(rID, ":", "");
		
		rID += "-"+currentDate.getTime();
		

        String agentName = new StringBuffer(process.getNode().getMonitor().getName()).append("_").append(process.getNode().getName()).append("_").append(process.getPid()).append("_").append(rID).append("_").append(element.getParser().getDescription()).toString();

        agentName = HyadesUtil.change(agentName, " ", "");

        String pPath = process.eResource().getURI().toString();
        IPath path = new Path(pPath);

        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }

        String fileName = agentName + getAgentNamePostfix(element);
        IPath filePath = new Path(pPath).append(fileName);

        URI uri = URI.createURI(filePath.toString());

        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
		agDoc.setModified(true);
        EList agExt = agDoc.getContents();

        UIPlugin.getDefault().getResourceSet().getResources().add(agDoc); // prevents reloading later

        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();

        //create process element
        agent = factory.createTRCAgentProxy();
        agent.setName(name);
        agent.setType(type);

        agent.setProcessProxy(process);
        process.getAgentProxies().add(agent);

        TRCAgent ag = factory.createTRCAgent();

        ag.setAgentProxy(agent);
        ag.setType(type);
        agExt.add(ag);

        // adding support for multiple files
//        SaveUtil.addDocument(agDoc);

        return ag;
    }

    /**
	 * @param element
	 * @return
	 */
	private String getAgentNamePostfix(LogFileElement element) {
		String res=null;
		Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
		if(element.isUseLargeLogSupport() && store.contains(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE))
		{
			String activeDBType = store.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE);
			for (Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator(); iter.hasNext();) {
				Map.Entry entry = (Map.Entry) iter.next();
				if(entry.getKey() instanceof String)
				{
					IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
					String postfix = (String)entry.getKey();
					if(postfix.endsWith(".trcadb") && hyadesResourceFactory.getStoreType(postfix).equals(activeDBType))
					{
						return postfix;
					}
				}
			}
		}
		if(res==null)
			res = ".trcaxmi";
		return res;
	}

    /*
     *
     */
    private TRCProcessProxy createProcess(IContainer container, TRCNode node, LogFileElement element) {
        int pID = 0;

        String logPath = "";
        Hashtable elems = getUserInput(element, false);

        Iterator iterator = elems.keySet().iterator();

        if (iterator.hasNext()) {
            logPath += elems.get(iterator.next()).toString();
        }

        while (iterator.hasNext()) {
            logPath += (" " + elems.get(iterator.next()).toString());
        }

        TRCProcessProxy process = null;
        EList processes = node.getProcessProxies();
        Iterator i = processes.iterator();
        int counter = 0;

        while (i.hasNext()) {
            process = (TRCProcessProxy) i.next();
            counter++;

            if ((process.getName() != null) && process.getName().equals(logPath)) {
                return process;
            }
        }

        TRCMonitor monitor = node.getMonitor();

        String rID = (new Date()).toString();

        rID = HyadesUtil.change(rID, " ", "");
        rID = HyadesUtil.change(rID, ":", "");

        String processName = node.getMonitor().getName() + "_" + node.getName() + "_" + counter + "_" + pID;

        String fileName = processName + "." + TraceConstants.PROCESS_EXT;
        IPath path = container.getFullPath().append(fileName);
        URI uri = URI.createURI("platform:/resource" + path.toString());

        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();

        UIPlugin.getDefault().getResourceSet().getResources().add(pDoc); // prevents reloading later

        // adding support for multiple files
//        SaveUtil.addDocument(pDoc);

        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();

        process = factory.createTRCProcessProxy();
        process.setPid(pID);

        /* Ensure the runtime UUID is set on the process object */
        process.setRuntimeId(String.valueOf(pID));

        process.setName(logPath);
        process.setLaunchMode(0); //attach                       

        process.setNode(node);
        pExt.add(process);
        final TRCProcessProxy fProcess = process;
		
		refreshView(fProcess);		
        
        return process;
    }

    /**
     * Initializes states of the controls from the preference store.
     */
    private void initializeValues() {
        IPluginRegistry reg = Platform.getPluginRegistry();

        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");

        for (int idx = 0; idx < config.length; idx++) {
            IConfigurationElement elem = config[idx];

            if (logParserId.trim().equals(elem.getAttribute("id").trim())) {
                _parser = new LogParserItem(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("ui_name"), elem.getAttribute("description"));
                _parser.setConfigurationElement(elem);
                _parser.setClass(elem.getAttribute("class"));
                _parser.setUIType(elem.getAttribute("ui_type"));

                String iconPath = elem.getAttribute("icon");

                if ((iconPath != null) && !iconPath.equals("")) {
                    URL pluginURL = elem.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();

                    try {
                        URL url = new URL(pluginURL, iconPath);
                        ImageDescriptor image = ImageDescriptor.createFromURL(url);

                        _parser.setImageDescriptor(image);
                    } catch (Exception exc) {
                        // if the URL does not have a valid format, just log and ignore the exception
                        IStatus status = new Status(IStatus.ERROR, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", exc); //$NON-NLS-1$

                        LogUIPlugin.getDefault().getLog().log(status);

                        continue;
                    }
                }

                IConfigurationElement[] felems = elem.getChildren("field");

                for (int i = 0; i < felems.length; i++) {
                    IConfigurationElement felem = felems[i];
                    ParserField pfield = new ParserField(felem.getAttribute("id"), felem.getAttribute("name"));
					pfield.setConfigurationElement(felem);
                    pfield.setDefaultValue(felem.getAttribute("defaultValue"));
                    pfield.setContextId(felem.getAttribute("helpContextId"));
                    pfield.setTooltip(felem.getAttribute("tooltip"));
                    pfield.setFilters(felem.getAttribute("browseType"));
                    pfield.useBrowse(felem.getAttribute("useBrowse").equals("true"));
                    pfield.setUiType(felem.getAttribute("ui_type"));
					pfield.setListener(felem.getAttribute("listener"));

                    _parser.addEntry(pfield);
                }
                
				IConfigurationElement[] fparameters = elem.getChildren("parserParameter");
				for(int i=0; i<fparameters.length; i++)
				{
				   IConfigurationElement fparameter = fparameters[i];
				   ParserParameter para = new ParserParameter(fparameter.getAttribute("name"),fparameter.getAttribute("value"));
				   _parser.addParameter(para);			   
				}
            }
        }
    }

    private void openLogView(TRCAgent agent) {
    	
		IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
		IAssociationMapping mapping = registry.getAssociationMapping(HyadesUIPlugin.EP_ANALYZER_EXTENSIONS);
    	
		if(mapping == null)
			return;
    	
		IAssociationDescriptor[] array = mapping.getAssociationDescriptors(agent.getType());

		if(array.length > 0)
		{
			IAssociationDescriptor desc = array[0];
			try {
					
				IAction action = (IAction)desc.createImplementationClassInstance();
				
				if(action != null)
				{					
					action.run();
				}								
			} catch (Exception exc) {
				exc.printStackTrace();
			}			
		}
		IWorkbenchPage page = UIPlugin.getActivePage();
		PDProjectExplorer pdViewer = (PDProjectExplorer) page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		if(pdViewer!=null){							
			pdViewer.getViewer().refresh();
		}
    }

    //~ Inner Classes ------------------------------------------------------------------------------

    /* RKD:  ProcessListenerImpl to be instantiated and used by the importers */
    class ProcessListenerImpl implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy process, TRCAgentProxy agent) {
            trcProcess = process;
            trcAgent = agent;
        }

        public void processExited(Process process) {
            trcAgent.setActive(false);
            trcAgent.setAttached(false);
            trcAgent.setMonitored(false);

            Display d = fShell.getDisplay();

            d.asyncExec(new Runnable() {
                    public void run() {
                        //update ui
                        fViewer.getViewer().refresh(trcAgent);
                    }
                });
        }

        public void processLaunched(Process process) {
            try {
                if (trcProcess != null) {
                    trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    trcProcess.setRuntimeId(process.getUUID());
                    trcProcess.setActive(true);

                    /*Display d = fShell.getDisplay();

                    d.asyncExec(new Runnable() {
                            public void run() {
                                //update ui
                                fViewer.getViewer().refresh(trcProcess);
                                fViewer.selectObject(trcAgent);
                            }
                        });*/
                }
            } catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
    
    class LogAgentListener implements AgentListener{
		
		private TRCAgentProxy aproxy;
		private TRCAgent trcAgent ;
		private TRCProcessProxy trcProcess ;

		public LogAgentListener(TRCAgent trcAgent, TRCAgentProxy aproxy, TRCProcessProxy trcProcess) {
			this.aproxy = aproxy;
			this.trcAgent = trcAgent;
			this.trcProcess = trcProcess;
		}
		public void agentActive(Agent agent) {
	                    
			aproxy.setActive(true);
			aproxy.setAttached(true);
			aproxy.setMonitored(true);
			LoadersUtils.registerAgentInstance(aproxy, agent);
	

			Display d = fShell.getDisplay();

			d.asyncExec(new Runnable() {
					public void run() {
						//update ui
						ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

						event.setSource(aproxy);
						event.setType(ProfileEvent.START_MONITOR);
						UIPlugin.getDefault().notifyProfileEventListener(event);
					}
				});

			try {
				XMLTraceDataProcessor dataProcessor = new XMLTraceDataProcessor(trcAgent.getAgentProxy()){
					/* (non-Javadoc)
					 * @see org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor#dataServerExited()
					 */
					public void dataServerExited()
					{
						super.dataServerExited();
						LoadersUtils.deregisterAgentInstance(aproxy);
						Display d = fShell.getDisplay();
						d.asyncExec(new Runnable() {
								public void run() {
									//update ui
									ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

									event.setSource(aproxy);
									event.setType(ProfileEvent.UPDATE_MODEL);
									UIPlugin.getDefault().notifyProfileEventListener(event);
								}
							});
						
						
				
//											loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
					}
				};
//									dataProcessor.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);

				agent.startMonitoring(dataProcessor);
        
			} catch (Exception e) {
				final String agentErrorMessage = e.toString();

				Display d2 = fShell.getDisplay();

				d2.asyncExec(new Runnable() {
						public void run() {
							MessageDialog.openError(UIPlugin.getActiveWorkbenchShell(), LogUIPlugin.getResourceString("LOGGING_MESSAGE"), agentErrorMessage);
						}
					});
			}
		}

		public void agentInactive(Agent agent) {
			aproxy.setActive(false);
			aproxy.setAttached(false);
			aproxy.setMonitored(false);

			trcProcess.setActive(false);

			Display d = fShell.getDisplay();

			d.asyncExec(new Runnable() {
					public void run() {
						//update ui
						ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

						event.setSource(aproxy);
						event.setType(ProfileEvent.TERMINATE);
						UIPlugin.getDefault().notifyProfileEventListener(event);
					}
				});
		}

		public void error(Agent agent, String errorId, String message) {
			final String errMsg = errorId.concat(": ").concat(message);
			Display d = fShell.getDisplay();

			d.asyncExec(new Runnable() {
					public void run() {
						MessageDialog.openError(UIPlugin.getActiveWorkbenchShell(), LogUIPlugin.getResourceString("LOGGING_MESSAGE"), errMsg);
					}
				});
		}

		public void handleCommand(Agent agent, CommandElement command) {
		}
	    
    }
    
    class ErrorAgentListener implements AgentListener{

		public ErrorAgentListener(){
		}
		
		public void agentActive(Agent agent) {
 
			try {
				agent.startMonitoring(new DataProcessor() {
					public void incommingData(byte[] buffer, int length, java.net.InetAddress peer) {
						final String agentErrorMessage = new String(buffer, 0, length);

						Display d = fShell.getDisplay();

						d.asyncExec(new Runnable() {
							public void run() {
								MessageDialog.openError(fShell, LogUIPlugin.getResourceString("LOGGING_MESSAGE"), agentErrorMessage);
							}
						});
					}

					public void incommingData(char[] buffer, int length, java.net.InetAddress peer) {
					}

					public void invalidDataType(byte[] data, int length, java.net.InetAddress peer) {
					}

					public void waitingForData() {
					}
				});
			} catch (Exception e) {
				final String agentErrorMessage = e.toString();

				Display d2 = fShell.getDisplay();

				d2.asyncExec(new Runnable() {
						public void run() {
							MessageDialog.openError(fShell, LogUIPlugin.getResourceString("LOGGING_MESSAGE"), agentErrorMessage);
						}
					});
			}
		}

		public void agentInactive(Agent agent) {
		}

		public void error(Agent agent, String errorId, String message) {
			final String errMsg = errorId.concat(": ").concat(message);
			Display d = fShell.getDisplay();

			d.asyncExec(new Runnable() {
					public void run() {
						MessageDialog.openError(fShell, LogUIPlugin.getResourceString("LOGGING_MESSAGE"), errMsg);
					}
				});
		}

		public void handleCommand(Agent agent, CommandElement command) {
		}
	}    
}
