/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class LogParserUI implements SelectionListener
{
	private Table  _list;
	private Label  _description;
	private ArrayList _images;
	private ArrayList _parserTable = new ArrayList();
	private LogParserItem _parser;
	private int _max = 1;
	private LogFileDetailsUI _detailsUI;        
    
	public LogParserUI(LogFileDetailsUI detailsUI) {
		_detailsUI = detailsUI;
		_images = new ArrayList();
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (4/26/2001 3:45:54 PM)
	 * @param parent com.ibm.swt.widgets.Composite
	 */
	public Composite createControl(Composite parent)
	{		
		Composite result = new Composite(parent, SWT.NONE);
		result.setLayoutData(GridUtil.createFill());
		result.setLayout(new GridLayout());
	
		Label desc = new Label(result, SWT.NONE);
		desc.setLayoutData(GridUtil.createHorizontalFill());   
		desc.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
	
		_list = new Table(result, SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.FULL_SELECTION|SWT.SINGLE);
		GridData data = GridUtil.createHorizontalFill();
		data.widthHint = 400;
		data.heightHint = 70;
		_list.setLayoutData(data);
		
		_description = new Label(result, SWT.WRAP);
		data = GridUtil.createHorizontalFill();
		data.heightHint = 30;
		data.widthHint = 400;
		_description.setLayoutData(data);
		
		_list.addSelectionListener(this);
	
		initializeValues();
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp
		(_list,
			LogUIPlugin.getPluginId()+".parserlist");					
		
			
		return result;
	}
	
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues()
	{
		Collection parsers = _detailsUI.getParserRegistry().values();
		
		for (Iterator iter = parsers.iterator(); iter.hasNext();) {			
			_parserTable.add(iter.next());
		}		
		initializeUI();	
	}
	
	private void initializeUI()
    {
    	Collections.sort(_parserTable, new Comparator(){
			public int compare(Object o1, Object o2){    	
				return ((LogParserItem)o1).getDescription().compareToIgnoreCase(((LogParserItem)o2).getDescription());
			}
    	});
    	
    	for(int idx=0; idx<_parserTable.size(); idx++)
    	{
    		LogParserItem parser = (LogParserItem)_parserTable.get(idx);
    		
			TableItem item = new TableItem(_list, SWT.NONE);
			item.setText(parser.getUIName());
			item.setData(parser);
			
			if(parser.getImageDescriptor() == null)
			  continue;
			
			Image image = parser.getImageDescriptor().createImage();
			item.setImage(image);
			_images.add(image);    		
    	}
    	
    	if(_parserTable.size() > 0)
    	{
    	   LogParserItem item = _detailsUI.getLogFileElement().getParser();
		   if(item==null){	
		   	 _parser = (LogParserItem)_parserTable.get(0);
			 _list.setSelection(0);
		   }else{
		   	 _parser = item;
		   	 _list.setSelection(_detailsUI.indexOf(_parser));
		   }
		   
		   _detailsUI.setSelectedParser(_parser);
    	   _description.setText(_parser.getDescription());
    	}
    	
    }	

	public void widgetDefaultSelected(SelectionEvent e) {}
	
	public void widgetSelected(SelectionEvent e)
	{
		if(e.widget == _list)
		{
		   TableItem[] selected = _list.getSelection();
		   if(selected.length > 0)
		   {				
				_parser = (LogParserItem)selected[0].getData();				
				_detailsUI.setSelectedParser(_parser);
				_description.setText(_parser.getDescription());
		   }

		}
	}
	
	
	public LogParserItem getParser()
	{
	   return _parser;		
	}
	

	public int getMaximumFields()
	{
		return _max;
	}
	
	public int getParserCount(){
		return _list.getItemCount();
	}
	
	public int indexOf(LogParserItem parser){
		TableItem[] items = _list.getItems();
		for (int i = 0; i < items.length; i++) {
			if(((LogParserItem)items[i].getData()).getDescription().equals(parser.getDescription())){
				return i;
			}
		}
		return -1;
	}
	
	public void dispose()
	{
		for(int idx=0; idx<_images.size(); idx++)
		{
			Image image = (Image)_images.get(idx);
			if(image != null && !image.isDisposed())
			   image.dispose();
		}
		
		_images.clear();
	}
	
	public boolean finish(){
		TableItem[] sel = _list.getSelection();
		if(sel.length==0){
			return false;
		}
		return true;
	}
}
