/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;

/**
 * This is the record for a class definition.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordClassDef {

    /**
     * the number of records to provide a unique object ID
     */
    private static int _numberRecords = 0;

    private int transientThreadIdRef = 0;
    private int threadIdRef = 0;
    private String time = null;
    private int numInterfaces = 0;
    private String interfaceNames = null;
    private int transientClassId = 0;
    private final int classId;
    private String sourceName = null;
    private String classLoader = null;
    private String superclass = null;
    private int transientObjIdRef = 0;
    private int objIdRef = 0;
    private final String name;
    private String access = null;
    private int numStaticFields = 0;
    private int numMethods = 0;
    private int numInstanceFields = 0;
    private String collationValue = null;
    private String traceIdRef = null;


    /**
     * Create a record for a class definition with a unique ID.
     * 
     * @param name  the name of the class
     */
    public RecordClassDef(String name) {

        /* Obtain a unique ID for this object. */
        synchronized (this.getClass()) {
            classId = ++_numberRecords;
        }
        this.name = name;
    }


    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string. 
     */
    public String toString() {

        return "<classDef classId=\"" + classId + "\"" + " name=\"" + name + "\"" +
               (transientThreadIdRef == 0 ? "" : " transientThreadIdRef=\"" + transientThreadIdRef + "\"") +
               (threadIdRef == 0 ? "" : " threadIdRef=\"" + threadIdRef + "\"") +
               (time == null ? "" : " time=\"" + time + "\"") +
               (numInterfaces == 0 ? "" : " numInterfaces=\"" + numInterfaces + "\"") +
               (interfaceNames == null ? "" : " interfaceNames=\"" + interfaceNames + "\"") +
               (transientClassId == 0 ? "" : " transientClassId=\"" + transientClassId + "\"") +
               (sourceName == null ? "" : " sourceName=\"" + sourceName + "\"") +
               (classLoader == null ? "" : " classLoader=\"" + classLoader + "\"") +
               (superclass == null ? "" : " superclass=\"" + superclass + "\"") +
               (transientObjIdRef == 0 ? "" : " transcientObjIdRef=\"" + transientObjIdRef + "\"") +
               (objIdRef == 0 ? "" : " objIdRef=\"" + objIdRef + "\"") +
               (access == null ? "" : " access=\"" + access + "\"") +
               (numStaticFields == 0 ? "" : " numStaticFields=\"" + numStaticFields + "\"") +
               (numMethods == 0 ? "" : " numMethods=\"" + numMethods + "\"") +
               (numInstanceFields == 0 ? "" : " numInstanceFields=\"" + numInstanceFields + "\"") +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") +
               (traceIdRef == null ? "" : " traceIdRef=\"" + traceIdRef + "\"") + "/>";
    }


    public void setAccess(String access) {
        this.access = access;
    }


    public void setClassLoader(String classLoader) {
        this.classLoader = classLoader;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }


    public void setInterfaceNames(String interfaceNames) {
        this.interfaceNames = interfaceNames;
    }


    public void setNumInstanceFields(int numInstanceFields) {
        this.numInstanceFields = numInstanceFields;
    }


    public void setNumInterfaces(int numInterfaces) {
        this.numInterfaces = numInterfaces;
    }


    public void setNumMethods(int numMethods) {
        this.numMethods = numMethods;
    }


    public void setNumStaticFields(int numStaticFields) {
        this.numStaticFields = numStaticFields;
    }


    public void setObjIdRef(int objIdRef) {
        this.objIdRef = objIdRef;
    }


    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }


    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }


    public void setThreadIdRef(int threadIdRef) {
        this.threadIdRef = threadIdRef;
    }


    public void setTime(String time) {
        this.time = time;
    }


    public void setTraceIdRef(String traceIdRef) {
        this.traceIdRef = traceIdRef;
    }


    public void setTransientClassId(int transientClassId) {
        this.transientClassId = transientClassId;
    }


    public void setTransientObjIdRef(int transientObjIdRef) {
        this.transientObjIdRef = transientObjIdRef;
    }


    public void setTransientThreadIdRef(int transientThreadIdRef) {
        this.transientThreadIdRef = transientThreadIdRef;
    }


    public String getAccess() {
        return access;
    }


    public int getClassId() {
        return classId;
    }


    public String getClassLoader() {
        return classLoader;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public String getInterfaceNames() {
        return interfaceNames;
    }


    public String getName() {
        return name;
    }


    public int getNumInstanceFields() {
        return numInstanceFields;
    }


    public int getNumInterfaces() {
        return numInterfaces;
    }


    public int getNumMethods() {
        return numMethods;
    }


    public int getNumStaticFields() {
        return numStaticFields;
    }


    public int getObjIdRef() {
        return objIdRef;
    }


    public String getSourceName() {
        return sourceName;
    }


    public String getSuperclass() {
        return superclass;
    }


    public int getThreadIdRef() {
        return threadIdRef;
    }


    public String getTime() {
        return time;
    }


    public String getTraceIdRef() {
        return traceIdRef;
    }


    public int getTransientClassId() {
        return transientClassId;
    }


    public int getTransientObjIdRef() {
        return transientObjIdRef;
    }


    public int getTransientThreadIdRef() {
        return transientThreadIdRef;
    }
}
