/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for a thread start.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordThreadStart {

    /**
     * the number of records to provide a unique object ID
     */
    private static int numberRecords = 0;

    private int transientThreadId = 0;
    private final int threadId;
    private String time = null;
    private String groupName = null;
    private String parentName = null;
    private int transientObjIdRef = 0;
    private int objIdRef = 0;
    private String threadName = null;
    private String collationValue = null;
    private String traceIdRef = null;


    /**
     * Create a record for a new threa with a unique ID.
     */
    public RecordThreadStart() {

        /* Obtain a unique ID for this object. */
        synchronized(this.getClass()) {
            this.threadId = ++numberRecords;
        }
    }


    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string. 
     */
    public String toString() {

        return "<threadStart threadId=\"" + threadId + "\" " +
               (transientThreadId == 0 ? "" : " transientThreadIdRef=\"" + transientThreadId + "\"") +
               (time == null ? "" : " time=\"" + time + "\"") +
               (groupName == null ? "" : "\" groupName=\"" + groupName + "\"") +
               (parentName == null ? "" : "\" parentName=\"" + parentName + "\"") +
               (transientObjIdRef == 0 ? "" : " transcientObjIdRef=\"" + transientObjIdRef + "\"") +
               (objIdRef == 0 ? "" : " objIdRef=\"" + objIdRef + "\"") +
               (threadName == null ? "" : "threadName=\"" + threadName + "\"") +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") +
               (traceIdRef == null ? "" : " traceIdRef=\"" + traceIdRef + "\"") + "/>";
    }


    public static int getNumberRecords() {
        return numberRecords;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public String getGroupName() {
        return groupName;
    }


    public int getObjIdRef() {
        return objIdRef;
    }


    public String getParentName() {
        return parentName;
    }


    public int getThreadId() {
        return threadId;
    }


    public String getThreadName() {
        return threadName;
    }


    public String getTime() {
        return time;
    }


    public String getTraceIdRef() {
        return traceIdRef;
    }


    public int getTransientObjIdRef() {
        return transientObjIdRef;
    }


    public int getTransientThreadId() {
        return transientThreadId;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }


    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }


    public void setObjIdRef(int objIdRef) {
        this.objIdRef = objIdRef;
    }


    public void setParentName(String parentName) {
        this.parentName = parentName;
    }


    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }


    public void setTime(String time) {
        this.time = time;
    }


    public void setTraceIdRef(String traceIdRef) {
        this.traceIdRef = traceIdRef;
    }


    public void setTransientObjIdRef(int transientObjIdRef) {
        this.transientObjIdRef = transientObjIdRef;
    }


    public void setTransientThreadId(int transientThreadId) {
        this.transientThreadId = transientThreadId;
    }
}
