/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.execution.recorder.http.remote;
import java.util.HashMap;
import java.net.Socket;
import java.util.Iterator;
import java.util.Set;
//import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
/**
 * @author mdunn
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class GlobalSocketList {
	private static HashMap socketList = new HashMap();
	public static void add(String key, CleanupObj thisClean) {
		PacketWriter tmpWriter = null;
		int numSockets = 0;
		synchronized (socketList) {
			try {
				socketList.put(key, thisClean);
				numSockets = socketList.size();
				tmpWriter = thisClean.getThisWriter();
				//tmpWriter.writeRecorderMessage(1, "After Add Key: " + key + " Size is: " + numSockets);
			} catch (Exception e) {
			}
		}
	}
	public static void remove(String key, PacketWriter tmpWriter) {
		int numSockets = 0;
		synchronized (socketList) {
			socketList.remove(key);
			numSockets = socketList.size();
			//tmpWriter.writeRecorderMessage(1, "After Remove Key: " + key + " Size is: " + numSockets);
		}
	}
	public static void killAllOpenSockets(PacketWriter tmpWriter) {
		Set thisSet = socketList.keySet();
		Iterator it = thisSet.iterator();
		String thisKey = "";
		Socket thisSocket = null;
		int numSockets = 0;
		CleanupObj tmpCleanup = null;
		synchronized (socketList) {
			numSockets = thisSet.size();

			if (numSockets > 0) {
				
				try {
					Thread.yield();
					Thread.sleep(1000);
				} catch (InterruptedException e) {
				}
				while (it.hasNext()) {
					thisKey = (String) it.next();
					//thisSocket = (Socket)socketList.get(thisKey);
					tmpCleanup = (CleanupObj) socketList.get(thisKey);
					thisSocket = tmpCleanup.getThisSocket();
					
					try {
						thisSocket.close();
						Thread.yield();
					} catch (Exception ioe) {
						System.out.println("In killAllOpenSockets() exception: "
										+ ioe.getMessage());
					}
				}
			}
		}
	}
	public static void writeCloseMessages(PacketWriter tmpWriter) {

		String thisKey = "";
		Socket thisSocket = null;
		int numSockets = 0;
		CleanupObj tmpCleanup = null;
		String tmpNumberStr = "";
		
		try {
			// let close() finish and write close message if it can 
			Thread.yield();
			Thread.sleep(1000);
		} catch (InterruptedException e) {
		}
		
		synchronized (socketList) {
			Set thisSet = socketList.keySet();
			Iterator it = thisSet.iterator();
			numSockets = thisSet.size();

			if (numSockets > 0) {
				
				while (it.hasNext()) {
					thisKey = (String) it.next();
					tmpCleanup = (CleanupObj) socketList.get(thisKey);
					thisSocket = tmpCleanup.getThisSocket();
					try {
						tmpNumberStr = tmpCleanup.getThisConnection();
						tmpWriter.writeCloseConnectionInfo(tmpNumberStr);
						thisSocket.close();
						Thread.yield();
					} catch (Exception ioe) {
						System.out.println("In writeCloseMessages() exception: "
										+ ioe.getMessage());
					}
				}
			}
		}
	}
}