/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;


/**
 * @author ptasnik@us.ibm.com
 *
 * Function:  Custom server socket that can accept
 *            Sockets of type PeekSocket.  
 */
public class PeekServerSocket extends ServerSocket {

	/**
	 * @throws java.io.IOException
	 */
	public PeekServerSocket() throws IOException {
		super();
	}

	/**
	 * @param port
	 * @throws java.io.IOException
	 */
	public PeekServerSocket(int port) throws IOException {
		super(port);
	}

	/**
	 * @param port
	 * @param backlog
	 * @throws java.io.IOException
	 */
	public PeekServerSocket(int port, int backlog) throws IOException {
		super(port, backlog);		
	}

	/**
	 * @param port
	 * @param backlog
	 * @param bindAddr
	 * @throws java.io.IOException
	 */
	public PeekServerSocket(int port, int backlog, InetAddress bindAddr)
		throws IOException {
		super(port, backlog, bindAddr);		
	}
	
	
	/**
	 * Override server socket accept to return
	 * a empty PeekSocket.  implAccept() does
	 * all the work to make it connected to
	 * the client socket.
	 */

	public PeekSocket acceptPeekSocket() throws IOException {
		PeekSocket s = new PeekSocket();
		implAccept(s);
		return s;
	}


	public static void main(String[] args) {
	try {
		PeekServerSocket server_sock = new PeekServerSocket (4444);
		PeekSocket client_sock;
		Thread myThread = new Thread (server_sock.new TestPeekServerSocket());
		myThread.start ();
		
		while (true) {
			System.out.println ("Server - waiting to accept ...");
			client_sock = server_sock.acceptPeekSocket();
			System.out.println ("Server - accepted");
			
			int peek_int = client_sock.peek();
			System.out.println ("Server - peek_int=" + String.valueOf(peek_int));
			int peek_read = client_sock.getInputStream().read();
			System.out.println ("Server - peek_read=" + String.valueOf(peek_read));
			peek_read = client_sock.getInputStream().read();
			System.out.println ("Server - peek_read=" + String.valueOf(peek_read));
			
			client_sock.close();
		}
		
	} catch (Exception e) {
		e.printStackTrace ();
	}
	}
	
	private class TestPeekServerSocket implements Runnable {
		
		public void run () {
			byte data[] = new byte [20];
			data[0] = 'h';
			data[1] = 'e';
			
			while (true) {			
				try {
					System.out.println ("Client - sleeping");
					Thread.sleep(5000); // wait for server
					
					System.out.println ("Client - going to connect");
					Socket s = new Socket ("localhost", 4444);
					s.getOutputStream().write(data, 0, 2);
					System.out.println ("Client - wrote bytes");
					
				} catch (Exception e) {
					e.printStackTrace ();
				}
			}
		}
	}
}

