/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;

import org.eclipse.hyades.statistical.ui.EditorPlugin;

import java.util.*;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import org.eclipse.swt.widgets.*;

import org.eclipse.swt.layout.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class GraphTableEditor extends Composite implements ControlListener, DisposeListener, GraphSelectionSource, SelectionListener, FocusListener
{
	public static final int VAL_GRAPH = 0;
	public static final int VAL_NAME = 1;
	public static final int VAL_DESC = 2;
	public static final int VAL_RGB = 3;
	public static final int VAL_WIDTH = 4;
	public static final int VAL_STYLE = 5;
	public static final int VAL_XSLIDER = 6;
	public static final int VAL_YSLIDER = 7;
	public static final int VAL_SCALING = 8;
	
	private static double[] weights = new double[]{
		20,			//name
		10,			//description
		4,			//rgb
		7,			//
		7,
		12,
		12,
		6
	};
	
	
//	private Composite parent;

	private Control graph_control;

	private Table table;
	private int style;
	private TableViewer tableViewer = null;
	private Vector datas = new Vector();
	private boolean editable = true;
//	private ResourceBundle resourceBundle;
	private Vector listeners = new Vector();
	
	private ComboBoxCellEditor comboBoxWidthCellEditor;
	private ComboBoxCellEditor comboBoxStyleCellEditor;
	private ComboBoxCellEditor comboBoxSliderXCellEditor;
	private ComboBoxCellEditor comboBoxSliderYCellEditor;
	private ColorCellEditor colorCellEditor;

	private Integer[] sliderXChoices = new Integer[] {
			new Integer(1),
		};
	private String[] sliderXChoicesString = new String[] {
			"1",
		};
	private Integer[] sliderYChoices = new Integer[] {
			new Integer(1),
		};
	private String[] sliderYChoicesString = new String[] {
			"1",
		};

	private Integer[] widthChoices = new Integer[] {
			new Integer(1),
			new Integer(2),
			new Integer(3),
			new Integer(4),
			new Integer(5),
			new Integer(6),
			new Integer(7),
			new Integer(8),
			new Integer(9),
			new Integer(10),
		};
	private String[] widthChoicesString = new String[] {
			"1","2","3","4","5","6","7","8","9","10"
		};

	private Integer[] styleChoices = new Integer[] {
			new Integer(SWT.LINE_SOLID),
			new Integer(SWT.LINE_DOT),
			new Integer(SWT.LINE_DASH),
			new Integer(SWT.LINE_DASHDOT),
			new Integer(SWT.LINE_DASHDOTDOT),
	};
	private String[] styleChoicesString = new String[] {
		EditorPlugin.getString("GRAPH_LINE_SOLID"),
		EditorPlugin.getString("GRAPH_LINE_DOT"),
		EditorPlugin.getString("GRAPH_LINE_DASH"),
		EditorPlugin.getString("GRAPH_LINE_DASH_DOT"),
		EditorPlugin.getString("GRAPH_LINE_DASH_DOT_DOT"),
	};

	public void addListener(GraphTableEditorListener newListener) {
		listeners.add(newListener);
	}

	public void notifyListeners(Graph g) {
		for (int v = 0; v < listeners.size(); v++)
		{
			GraphTableEditorListener TCL = (GraphTableEditorListener) (listeners.elementAt(v));
			TCL.graphEdited(g);
		}
	}

	public void setEditable(boolean newValue)
	{
		editable = newValue;
	}

	public void widgetDisposed(DisposeEvent e) {
		dispose();
	}

	public GraphTableEditor(Composite parent, int style, Object[][] values, Control graph_control)
	{
		super(parent,style);
		
		this.graph_control = graph_control;

		parent.addDisposeListener(this);
		
//		this.parent = parent;
		this.style = style;
//		resourceBundle = ComptestResourceBundle.getInstance();

		for (int i = 0; i < datas.size(); i++) {
			try {
				GraphElement ge = (GraphElement)datas.get(i);
				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas = new Vector();
//		datas.clear();
		for (int i = 0; i < values.length; i++)
			datas.add(new GraphElement((Graph)values[i][0], (String)values[i][1], (String)values[i][2], (RGB)values[i][3], (Integer)values[i][4], (Integer)values[i][5], (Integer)values[i][6], (Integer)values[i][7], (Double)values[i][8] ));

		instantiate();
		
		addControlListener(this);
	}

	public void ensureGraphsValid() {

		for (int i = 0; i < datas.size(); i++) {
			GraphElement element = (GraphElement)datas.get(i);

			if (element.xslider.intValue() >= sliderXChoices.length) {
				element.xslider = new Integer(0);	
			}

			if (element.yslider.intValue() >= sliderYChoices.length) {
				element.yslider = new Integer(0);	
			}
		}
			
		if (tableViewer != null) tableViewer.refresh(true);
	}

	public void setXSliderChoices(Integer[] values, String[] names) {
		sliderXChoices = values;
		sliderXChoicesString = names;

		comboBoxSliderXCellEditor.setItems(names);

		ensureGraphsValid();
		
		redraw();
	}
	
	public void setYSliderChoices(Integer[] values, String[] names) {
		sliderYChoices = values;
		sliderYChoicesString = names;

		comboBoxSliderYCellEditor.setItems(names);

		ensureGraphsValid();

		redraw();
	}

	public void setValues(Object[][] values)
	{

		for (int i = 0; i < datas.size(); i++) {
			try {
				GraphElement ge = (GraphElement)datas.get(i);
				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas.clear();
		for (int i = 0; i < values.length; i++)
			datas.add(new GraphElement((Graph)values[i][0], (String)values[i][1], (String)values[i][2], (RGB)values[i][3], (Integer)values[i][4], (Integer)values[i][5], (Integer)values[i][6], (Integer)values[i][7], (Double)values[i][8] ));

		tableViewer.setInput(datas);
	}
/****
	private void instanciateActions()
	{
		insertAction = new BaseItemInsert(tableViewer, datas)
		{
			protected Object createObjectToInsert()
			{
				return new HostElement("name", "tcpip", "10000");
			}

			protected void endRun()
			{
				notifyListeners();
			}
		};

		removeAction = new BaseItemRemove(tableViewer, datas)
		{
			protected void endRun()
			{
				notifyListeners();
			}
		};

		moveUpAction = new BaseItemMoveUp(tableViewer, datas)
		{
			protected void endRun()
			{
				notifyListeners();
			}
		};

		moveDownAction = new BaseItemMoveDown(tableViewer, datas)
		{
			protected void endRun()
			{
				notifyListeners();
			}
		};

		baseViewForm.addAction(insertAction);
		baseViewForm.addAction(removeAction);
		baseViewForm.addActionSeparator();
		baseViewForm.addAction(moveUpAction);
		baseViewForm.addAction(moveDownAction);
	}
****/

	public Object[][] getValues()
	{
		Object[][] result = new Object[datas.size()][9];
		for (int v = 0; v < datas.size(); v++)
		{
			result[v][0] = ((GraphElement) datas.get(v)).graph;
			result[v][1] = ((GraphElement) datas.get(v)).name;
			result[v][2] = ((GraphElement) datas.get(v)).description;
			result[v][3] = ((GraphElement) datas.get(v)).color;
			result[v][4] = ((GraphElement) datas.get(v)).line_width;
			result[v][5] = ((GraphElement) datas.get(v)).line_style;
			result[v][6] = ((GraphElement) datas.get(v)).xslider;
			result[v][7] = ((GraphElement) datas.get(v)).yslider;
			result[v][8] = ((GraphElement) datas.get(v)).scaling;
		}
		return result;
	}

//	public void setLayoutData(Object layoutData)
//	{
//		if (baseViewForm != null)
//			baseViewForm.setLayoutData(layoutData);

//		this.layoutData = layoutData;
//	}

	public void dispose() {
		super.dispose();
		
		disposables.addAll(datas);
		
		for (int i = 0; i < disposables.size(); i++) {
			try {
			Object o = disposables.get(i);
			if (o != null) {
				if (o instanceof Widget) {
					((Widget)o).dispose();	
				} else if (o instanceof Color) {
					((Color)o).dispose();	
				} else if (o instanceof Image) {
					((Image)o).dispose();	
				} else {
					try {
						EditorPlugin.disposeObject(o);
					} catch (Throwable e) {
						EditorPlugin.DBG.warning("Class not found when disposing of "+o.getClass()+"/"+o+" ("+e+")");
					}
				}
			}
			} catch (Throwable e) {
				EditorPlugin.DBG.error("Problem disposing of objects",e);
			}
		}		
	}

ArrayList disposables = new ArrayList();

	public void instantiate()
	{
		
		GridLayout glayout = new GridLayout(1,false);
		glayout.marginWidth = 0;
		glayout.marginHeight = 0;
		glayout.horizontalSpacing = 0;
		glayout.verticalSpacing = 0;
		
		setLayout(glayout);

//		baseViewForm = ComptestPlugin.getPlugin().getUIFactory().createBaseViewForm(parent, style);
//		baseViewForm.setBorderVisible(true);
//		baseViewForm.setTitle(resourceBundle.getString("label.Hosts"));
//		if (layoutData != null)
//			baseViewForm.setLayoutData(layoutData);
	
		GridData gdata = new GridData();
		gdata.horizontalAlignment = GridData.FILL;
		gdata.verticalAlignment = GridData.FILL;
		gdata.grabExcessHorizontalSpace = true;
		gdata.grabExcessVerticalSpace = true;
		
//		Table table = ComptestPlugin.getPlugin().getUIFactory().createBaseTable(baseViewForm, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
//		Table table = new Table(this,SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
		table = new Table(this,SWT.FULL_SELECTION|SWT.HIDE_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(gdata);

		table.addSelectionListener(this);
		table.addFocusListener(this);

		disposables.add(table);

		TableColumn tc = null;
		(tc = new TableColumn(table, SWT.LEFT)).setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.LEFT)).setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_COLOR"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_WIDTH"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.LEFT)).setText(EditorPlugin.getString("TABLE_COLUMN_STYLE"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_HSLIDER"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_VSLIDER"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_MULTIPLIER"));
		disposables.add(tc);

		comboBoxWidthCellEditor = new ComboBoxCellEditor(table, widthChoicesString);
		comboBoxStyleCellEditor = new ComboBoxCellEditor(table, styleChoicesString);
		comboBoxSliderXCellEditor = new ComboBoxCellEditor(table, sliderXChoicesString);
		comboBoxSliderYCellEditor = new ComboBoxCellEditor(table, sliderYChoicesString);
		colorCellEditor = new ColorCellEditor(table);


		CellEditor[] cellEditors = new CellEditor[8];
		cellEditors[0] = new TextCellEditor(table);
		cellEditors[1] = new TextCellEditor(table);
		cellEditors[2] = colorCellEditor;
		cellEditors[3] = comboBoxWidthCellEditor;
		cellEditors[4] = comboBoxStyleCellEditor;
		cellEditors[5] = comboBoxSliderXCellEditor;
		cellEditors[6] = comboBoxSliderYCellEditor;
		cellEditors[7] = new TextCellEditor(table);

		for (int i = 0; i < cellEditors.length; i++) {
			disposables.add(cellEditors[i]);
		}
		
		ICellEditorListener cellListener = new ICellEditorListener()
		{
			public void applyEditorValue()
			{
				tableViewer.getTable().setFocus();
			}

			public void cancelEditor()
			{
				tableViewer.getTable().setFocus();
			}

			public void editorValueChanged(boolean oldValidState, boolean newValidState)
			{
			}
		};

		for(int i = 0; i < cellEditors.length; i++) {
			cellEditors[i].addListener(cellListener);		
		}
			
		TableLayout tableLayout = new TableLayout();
		tableLayout.addColumnData(new ColumnWeightData(32, 50, true)); //name
		tableLayout.addColumnData(new ColumnWeightData(28, 50, true)); //description
		tableLayout.addColumnData(new ColumnWeightData(6, 10, true)); //color
		tableLayout.addColumnData(new ColumnWeightData(6, 20, true)); //line width
		tableLayout.addColumnData(new ColumnWeightData(8, 30, true)); //line style
		tableLayout.addColumnData(new ColumnWeightData(16, 30, true)); //x slider
		tableLayout.addColumnData(new ColumnWeightData(16, 30, true)); //y slider
		tableLayout.addColumnData(new ColumnWeightData(12, 30, true)); //scaling
		table.setLayout(tableLayout);

		tableViewer = new TableViewer(table);
		tableViewer.setColumnProperties(new String[] {"name", "description", "color", "line width", "line style", "xslider", "yslider", "scaling"}); //$NON-NLS-1$ //$NON-NLS-2$
		tableViewer.setContentProvider(new GraphContentProvider());
		tableViewer.setLabelProvider(new GraphLabelProvider());
		tableViewer.setCellEditors(cellEditors);

		tableViewer.setCellModifier(new GraphCellModifier());
/*
		KeyListener keyListener = new KeyListener()
		{
			private Object lastElement;
			private int lastColumn;
			
			public void keyPressed(KeyEvent e)
			{
			}

			public void keyReleased(KeyEvent e)
			{
				if(e.character == ' ')
				{
					TableItem[] selections = tableViewer.getTable().getSelection();
					if(selections.length ==0)
						return;
						
					int columnCount = tableViewer.getTable().getColumnCount();
					Object element = tableViewer.getTable().getSelection()[0].getData();
					if(element == null)
						return;
						
					if(element.equals(lastElement))
					{
						lastColumn = (++lastColumn)%columnCount;
						if(lastColumn == 0)
							lastColumn=1;
					}
					else
					{
						lastElement = element;
						lastColumn = 1;
					}
					
					tableViewer.editElement(element, lastColumn);
				}	
			}
		};
		
		table.addKeyListener(keyListener);
*/
	}
	
	public class GraphElement
	{
		public Graph graph;
		public String name;
		public String description;
		public Integer line_width;
		public Integer line_style;
		public Integer xslider;
		public Integer yslider;
		public RGB color;
		public Double scaling;
		
		RGB black_rgb;

		Image image;
		GC image_gc;
		Color bg_col, fg_col;

		public GraphElement(Graph graph, String name, String description, RGB color, Integer line_width, Integer line_style, Integer x_slider, Integer y_slider, Double scaling)
		{
			this.graph = graph;
			this.name = name;
			this.description = description;
			this.line_width = line_width;
			this.line_style = line_style;
			this.xslider = x_slider;
			this.yslider = y_slider;
			this.color = color;
			this.scaling = scaling;

			black_rgb = new RGB(0,0,0);

			PaletteData palettedat = new PaletteData(new RGB[]{color,color});
			ImageData imgdat = new ImageData(11,11,1,palettedat);			
			image = new Image(getDisplay(),imgdat);

/*
			Image tmpimage = image;
			Color tmpcol = fg_col;

			image = new Image(getDisplay(),16,16);
			image_gc = new GC(image);
			image_gc.setBackground(graph_bg.getBackground());
			image_gc.fillRectangle(0,0,16,16);
			
			fg_col = new Color(getDisplay(),color);
			image_gc.setForeground(fg_col);
			image_gc.setLineStyle(graph.getLineStyle());
			image_gc.setLineWidth(graph.getLineWidth());
			image_gc.drawLine(0,7,16,7);
*/

			redrawImage();
		}

		public void update() {
			redrawImage();
		}
		
		public void redrawImage() {
/*
			Image tmpimage = image;
			Color tmpcol = fg_col;
			GC tmpgc = image_gc;

			image = new Image(getDisplay(),16,16);
			image_gc = new GC(image);
			image_gc.setBackground(graph_bg.getBackground());
			image_gc.fillRectangle(0,0,16,16);
			
			fg_col = new Color(getDisplay(),color);
			image_gc.setForeground(fg_col);
			image_gc.setLineStyle(graph.getLineStyle());
			image_gc.setLineWidth(graph.getLineWidth());
			image_gc.drawLine(0,7,16,7);

			tmpcol.dispose();
			tmpimage.dispose();
			tmpgc.dispose();
*/

			PaletteData palettedat = new PaletteData(new RGB[]{color,color});
			ImageData imgdat = new ImageData(11,11,1,palettedat);			
			Image tmpimage = image;

			image = new Image(getDisplay(),imgdat);

			tmpimage.dispose();

		}
		
		public void dispose() {
			image.dispose();	
		}
	}

	public class GraphLabelProvider extends LabelProvider implements ITableLabelProvider
	{

		public Image getColumnImage(Object element, int columnIndex)
		{
			Image columnImage = null;
			GraphElement graphElement = (GraphElement) element;
			switch (columnIndex)
			{
				case 2 :
					columnImage = graphElement.image;
					break;
			}
			
			return columnImage;
		}

		public String getColumnText(Object element, int columnIndex)
		{
			String columnText = null;
			GraphElement graphElement = (GraphElement) element;
			switch (columnIndex)
			{
				case 0 :
					columnText = graphElement.name;
					break;
				case 1 :
					columnText = graphElement.description;
					break;
				case 2 :
//					RGB tmp = graphElement.color;
//					columnText = "("+tmp.red+","+tmp.green+","+tmp.blue+")";		
					columnText = "";
					break;
				case 3 :
					columnText = ""+graphElement.line_width;
					break;
				case 4 :
					int index = 0;
					for (index = 0; index < styleChoices.length; index++) {
						if (graphElement.line_style.equals(styleChoices[index])) {
							break;
						}
					}
				
					columnText = styleChoicesString[index];
					break;
				case 5 :
					int xindex = graphElement.xslider.intValue();
					columnText = sliderXChoicesString[xindex];
					break;
				case 6 :
					int yindex = graphElement.yslider.intValue();
					columnText = sliderYChoicesString[yindex];
					break;
				case 7 :
					columnText = graphElement.scaling.toString();
					break;
			}
			return columnText;
		}
	}

	public static class GraphContentProvider implements IStructuredContentProvider
	{
		public Object[] getElements(Object input)
		{
			return ((Vector) input).toArray();
		}

		public void dispose()
		{
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
		{
		}
	}
	
	public class GraphCellModifier implements ICellModifier
	{
		public boolean canModify(Object element, String property)
		{
			GraphElement e = (GraphElement) element;
			if("name".equals(property)) //$NON-NLS-1$
			{
				return false;
			}
			else if ("description".equals(property))
			{
				return false;
			}
			return editable;
		}
		
		public Object getValue(Object element, String property)
		{
			GraphElement e = (GraphElement) element;
			if("name".equals(property)) //$NON-NLS-1$
			{
				return e.name;
			}
			else if ("description".equals(property))
			{
				return e.description;
			}
			else if("color".equals(property))
			{
				return e.color;
			}
			else if ("line width".equals(property))
			{
				return e.line_width;
			}
			else if ("line style".equals(property))
			{
				return e.line_style;
			}
			else if ("xslider".equals(property))
			{
				return e.xslider;
			}
			else if ("yslider".equals(property))
			{
				return e.yslider;
			}
			else if ("scaling".equals(property))
			{
				return ""+e.scaling;
			}
			else
			{
				return null;
			}
		}
		
		public void modify(Object element, String property, Object value)
		{
			Item item = (Item)element;
			GraphElement e = (GraphElement) item.getData();
			boolean changed = false;

			if("name".equals(property)) //$NON-NLS-1$
			{
			}
			else if("description".equals(property))
			{
			}
			else if("color".equals(property)) //$NON-NLS-1$
			{
				Control control = colorCellEditor.getControl();
				value = colorCellEditor.getValue();
				
				if(value != null) {
					
					if(!value.equals(e.color))
					{
						changed = true;
						e.color = (RGB)value;
						e.update();
					}
					
				}
			}
			else if("line width".equals(property)) //$NON-NLS-1$
			{
				Control control = comboBoxWidthCellEditor.getControl();
				if(control instanceof CCombo)
					value = new Integer(((CCombo)control).getSelectionIndex());
									
				int thisSelection = ((Integer) value).intValue();
				if(thisSelection > -1)
				{
					if(!widthChoices[thisSelection].equals(e.line_width))
					{
						changed = true;
						e.line_width = widthChoices[thisSelection];
					}
				}
			}
			else if("line style".equals(property)) //$NON-NLS-1$
			{
				Control control = comboBoxStyleCellEditor.getControl();
				if(control instanceof CCombo)
					value = new Integer(((CCombo)control).getSelectionIndex());
									
				int thisSelection = ((Integer) value).intValue();
				if(thisSelection > -1)
				{
					if(!styleChoices[thisSelection].equals(e.line_style))
					{
						changed = true;
						e.line_style = styleChoices[thisSelection];
					}
				}
			}
			else if("xslider".equals(property)) //$NON-NLS-1$
			{
				Control control = comboBoxSliderXCellEditor.getControl();
				if(control instanceof CCombo)
					value = new Integer(((CCombo)control).getSelectionIndex());
									
				int thisSelection = ((Integer) value).intValue();
				if(thisSelection > -1)
				{
					if(!sliderXChoices[thisSelection].equals(e.xslider))
					{
						changed = true;
						e.xslider = sliderXChoices[thisSelection];
					}
				}
			}
			else if("yslider".equals(property)) //$NON-NLS-1$
			{
				Control control = comboBoxSliderYCellEditor.getControl();
				if(control instanceof CCombo)
					value = new Integer(((CCombo)control).getSelectionIndex());
									
				int thisSelection = ((Integer) value).intValue();
				if(thisSelection > -1)
				{
					if(!sliderYChoices[thisSelection].equals(e.yslider))
					{
						changed = true;
						e.yslider = sliderYChoices[thisSelection];
					}
				}
			}
			else if("scaling".equals(property)) //$NON-NLS-1$
			{
				if(value == null)
					value = "1.0";
					
				try {
					Double d = new Double(value.toString());
					e.scaling = d;	
					changed = true;
				} catch (Throwable x) {
				}
			}

			if(changed)
			{
				notifyListeners(e.graph);
				tableViewer.refresh(e);
			}
		}
	}		
	
	public void expandColumns()
	{
		double weightTotal = 0;
		for (int i=0; i<tableViewer.getTable().getColumnCount(); i++) {
			weightTotal += weights[i];	
		}

		double multiplier = ((double)getSize().x) / weightTotal;

		for (int i = 0; i < tableViewer.getTable().getColumnCount(); i++) {
			int size = (int)(weights[i] * multiplier);
			((TableViewer)tableViewer).getTable().getColumn(i).setWidth( size );
		}
	}

	
	public void controlResized(ControlEvent event) {
		expandColumns();
	}
	
	public void controlMoved(ControlEvent e) {
		expandColumns();
	}
		
		
boolean has_focus = false;		
	public Graph getSelectedGraph() {
		if (!has_focus) return null;
		int n = table.getSelectionIndex();
		if (n == -1) return null;
		GraphElement element = (GraphElement)datas.get(n);
		return element.graph;
	}	

	public void redrawGraphs() {
		graph_control.redraw();	
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		redrawGraphs();
	}
	public void focusLost(FocusEvent e) {
		has_focus = false;
		redrawGraphs();
	}
	public void focusGained(FocusEvent e) {
		has_focus = true;
		redrawGraphs();
	}

}