/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.*;

import org.eclipse.hyades.model.statistical.*;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;


import java.util.*;

public class SDSnapshotObservationGraphSource implements GraphSource {

//SDCounterDescriptor sdc;
List times;
List values;

	public SDSnapshotObservationGraphSource(SDContiguousObservation sdc) {
//		test();
		
		times = sdc.getCreationTime();
		values = sdc.getValue();
	}

	public SDSnapshotObservationGraphSource(SDDiscreteObservation sdc) {
//		test();

		times = sdc.getCreationTime();
		values = sdc.getValue();
	}

	private void test() {
		ArrayList times = new ArrayList();
		ArrayList values = new ArrayList();
		
//		long t = System.currentTimeMillis();
		long t = 0;
		Random r = new Random(10);
		
		for (int i = 0; i < 100000; i++) {
			times.add(new Double(t));
			values.add(new Double(r.nextInt()));
			
			t += r.nextInt(1500);
		}
		
		List tmp1 = this.times;
		List tmp2 = this.values;
		
		this.times = times;
		this.values = values;
		
		int index = 0;
		int bcindex = 0;
		long tcrap = System.currentTimeMillis();
		r = new Random(10);
		for (int k = 0; k < 100; k++) {
			long search = t - r.nextInt(1000 * 100000);
			index = linearGetIndex(search);
			try {
EditorPlugin.DBG.info("Crap Get Index= , "+index+" , "+search+" , "+times.get(index)+" , "+times.get(index+1));			
			} catch (Exception e) {}
			
		}
		tcrap = System.currentTimeMillis()-tcrap;

		long tchop = System.currentTimeMillis();
		r = new Random(10);
		for (int k = 0; k < 100; k++) {
			long search = t - r.nextInt(1000 * 100000);
			bcindex = bchopGetIndex(search);
			try {
EditorPlugin.DBG.info("BChop Get Index= , "+bcindex+" , "+search+" , "+times.get(bcindex)+" , "+times.get(bcindex+1));			
			} catch (Exception e) {}

		}
		tchop = System.currentTimeMillis()-tchop;

EditorPlugin.DBG.info("Test times are: BCHOP "+tchop+" CRAP "+tcrap);
		
		this.times = tmp1;
		this.values = tmp2;
		
	}

	public int bchopGetIndex(double t) {

		int lower = 0;
		int higher = times.size()-1;

		double t1 = ((Number)times.get(lower)).doubleValue();
		double t2 = ((Number)times.get(higher)).doubleValue();

		if (t >= t2) {
			return times.size()-1;
		} else if (t <= t1) {
			return 0;
		} else {
			return bchopGetIndex(lower,higher,t);
		}//end if
	}
	
	private int bchopGetIndex(int lower, int higher, double t) {
		
		while (true) {
			
			if (higher-lower < 10) {
				for (int i = lower; i <= higher; i++) {
					Number T = (Number)times.get(i);
					if (T.doubleValue() > t) {
						i--;
						if (i < 0) return 0;
						if (i >= times.size()) return times.size()-1;
						
						return i;
					}
				}	
				return higher;
			}
	
			double t1 = ((Number)times.get(lower)).doubleValue();
			double t2 = ((Number)times.get(higher)).doubleValue();
	
//weighted heuristic
			double chop = (t - t1) / (t2 - t1);
			chop = chop * (double)((higher-lower)-2);
			chop = chop + ((double)lower) + 1.0d;

//centre-chop heuristic
//			double chop = lower + ((higher-lower)/2);

//			EditorPlugin.DBG.info("loop "+lower+" "+higher+" "+chop);
			
			double chop_t = ((Number)times.get((int)chop)).doubleValue();
			if (chop_t == t) {
				return (int)chop;
			} else if (chop_t > t) {
				higher = (int)chop;
			} else {
				lower = (int)chop;
			}

		}

//replaced this recursion with a simple loop - faster and more efficient
//		return bchopGetIndex(lower,higher,t);				
	}	
	
	

	public int linearGetIndex(double t) {
		if (times.size() != values.size()) {
			EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - "+times.size()+" "+values.size());
		}	
		
		for (int i = 0; i < times.size(); i++) {
			Number T = (Number)times.get(i);	
			if (T.doubleValue() > t) {
				i--;
				if (i == -1) return 0; 
				return i;
			}
		}
		return times.size()-1;
	}

	public double getSumBetween(double t, double t1) {
		if (times == null) return 0;
		if (times.size() == 0) return 0;	

		int index1 = bchopGetIndex(t);
		int index2 = bchopGetIndex(t1);
		
		if (times.size() != values.size()) {
			EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - "+times.size()+" "+values.size());
		}

		double sum = 0.0d;
		
		for (int i = index1; i < index2; i++) {
			Number num = (Number)values.get(i);
			sum += validate(num.doubleValue());
		} 

		return sum;		
	}

	public double getAverageBetween(double t, double t1) {
		if (times == null) return 0;
		if (times.size() == 0) return 0;	

		int index1 = bchopGetIndex(t);
		int index2 = bchopGetIndex(t1);
		
		if (times.size() != values.size()) {
			EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - "+times.size()+" "+values.size());
		}

		double sum = 0.0d;

		for (int i = index1; i < index2; i++) {
			Number num = (Number)values.get(i);
			sum += validate(num.doubleValue());
		} 

		double div = index2-index1;

		if (div > 1.0) {
			return ( sum / div );		
		} else {
			return sum;
		}
	}

	private double validate(double val) {
		if (Double.isNaN(val) || Double.isInfinite(val)) {
			//invalid value - convert to zero
			val = 0.0;	
		}
		return val;
	}

	public double getValueAt(double t) {
		if (times == null) return 0;
		if (times.size() == 0) return 0;	

		int index = bchopGetIndex(t);

		if (times.size() != values.size()) {
			EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - "+times.size()+" "+values.size());
		}

		Number D = (Number)values.get(index);
		
		return validate(D.doubleValue());
	}

	public double getValueMin() {
		if (values == null) return Double.NEGATIVE_INFINITY;
		if (values.size() == 0) return Double.NEGATIVE_INFINITY;
		
		double Vmin = Double.MAX_VALUE;
		double Vmax = Double.MIN_VALUE;
		
		Iterator it = values.iterator();
		double tmp;
		while (it.hasNext()) {
			Number V = (Number)it.next();	
			tmp = V.doubleValue();
			
			if (tmp > Vmax) Vmax = tmp;
			if (tmp < Vmin) Vmin = tmp;
		}
		
		return Vmin;
	}

	public double getValueMax() {
		if (values == null) return Double.POSITIVE_INFINITY;
		if (values.size() == 0) return Double.POSITIVE_INFINITY;

		double Vmin = Double.MAX_VALUE;
		double Vmax = Double.MIN_VALUE;
		
		Iterator it = values.iterator();
		double tmp;
		while (it.hasNext()) {
			Number V = (Number)it.next();	
			tmp = V.doubleValue();
			
			if (tmp > Vmax) Vmax = tmp;
			if (tmp < Vmin) Vmin = tmp;
		}
		
		return Vmax;
	}

	public double getMin() {
		if (times == null) return Double.NEGATIVE_INFINITY;
		if (times.size() == 0) return Double.NEGATIVE_INFINITY;
		Number L = (Number)times.get(0);
		return L.doubleValue();
	}
	public double getMax() {
		if (times == null) return Double.POSITIVE_INFINITY;
		if (times.size() == 0) return Double.POSITIVE_INFINITY;
		Number L = (Number)times.get(times.size()-1);
		return L.doubleValue();
	}
}