/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.junit.editor.SourceInfoViewer;

public class AdjustSourceInfoPage 
extends WizardPage
{
	private IImplementor implementor;
	private SourceInfoViewer sourceInfoViewer;
	
	/**
	 * Constructor for AdjustSourceInfoPage
	 * @param pageName
	 */
	public AdjustSourceInfoPage(IImplementor implementor)
	{
		super("AdjustSourceInfoPage");
		setTitle(TestJavaPlugin.getString("GEN_WTITLE"));
		setDescription(TestJavaPlugin.getString("ADJ_PG_DSC"));

		this.implementor = implementor;
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose()
	{
		implementor = null;
		sourceInfoViewer.dispose();
		super.dispose();
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent)
	{
		sourceInfoViewer = new SourceInfoViewer()
		{
			public void modifyText(ModifyEvent e)
			{
				super.modifyText(e);
				setPageComplete(validatePage());
			}	
		};
		Composite composite = sourceInfoViewer.createClient(parent, null, null);
		setControl(composite);
		
		sourceInfoViewer.setInitialFocus();
		sourceInfoViewer.setInput(implementor);
		setPageComplete(false);
	}
	
	protected boolean validatePage()
	{
		if(!JavaConventions.validateIdentifier(sourceInfoViewer.getClassName()).isOK())
		{
			setErrorMessage(TestJavaPlugin.getString("_ERROR_INV_CLS_NAME"));
			return false;
		}

		if(!JavaConventions.validatePackageName(sourceInfoViewer.getPackage()).isOK())
		{
			setErrorMessage(TestJavaPlugin.getString("_ERROR_INV_PCK_NAME"));
			return false;
		}
		
		setErrorMessage(null);
		return true;
	}
}
